/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.ListAllowedRepositoriesForGroupRequest;
import software.amazon.awssdk.services.codeartifact.model.ListAllowedRepositoriesForGroupResponse;

public class ListAllowedRepositoriesForGroupIterable
implements SdkIterable<ListAllowedRepositoriesForGroupResponse> {
    private final CodeartifactClient client;
    private final ListAllowedRepositoriesForGroupRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAllowedRepositoriesForGroupIterable(CodeartifactClient client, ListAllowedRepositoriesForGroupRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAllowedRepositoriesForGroupResponseFetcher();
    }

    public Iterator<ListAllowedRepositoriesForGroupResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> allowedRepositories() {
        Function<ListAllowedRepositoriesForGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.allowedRepositories() != null) {
                return response.allowedRepositories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAllowedRepositoriesForGroupResponseFetcher
    implements SyncPageFetcher<ListAllowedRepositoriesForGroupResponse> {
        private ListAllowedRepositoriesForGroupResponseFetcher() {
        }

        public boolean hasNextPage(ListAllowedRepositoriesForGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAllowedRepositoriesForGroupResponse nextPage(ListAllowedRepositoriesForGroupResponse previousPage) {
            if (previousPage == null) {
                return ListAllowedRepositoriesForGroupIterable.this.client.listAllowedRepositoriesForGroup(ListAllowedRepositoriesForGroupIterable.this.firstRequest);
            }
            return ListAllowedRepositoriesForGroupIterable.this.client.listAllowedRepositoriesForGroup((ListAllowedRepositoriesForGroupRequest)((Object)ListAllowedRepositoriesForGroupIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

