/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PackageVersionOriginType {
    INTERNAL("INTERNAL"),
    EXTERNAL("EXTERNAL"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PackageVersionOriginType> VALUE_MAP;
    private final String value;

    private PackageVersionOriginType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageVersionOriginType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageVersionOriginType> knownValues() {
        EnumSet<PackageVersionOriginType> knownValues = EnumSet.allOf(PackageVersionOriginType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PackageVersionOriginType.class, PackageVersionOriginType::toString);
    }
}

