/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourcePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutResourcePolicyResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, PutResourcePolicyResponse> {
    private static final SdkField<ResourcePolicy> RESOURCE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourcePolicy").getter(PutResourcePolicyResponse.getter(PutResourcePolicyResponse::resourcePolicy)).setter(PutResourcePolicyResponse.setter(Builder::resourcePolicy)).constructor(ResourcePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcePolicy").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(PutResourcePolicyResponse.getter(PutResourcePolicyResponse::revisionId)).setter(PutResourcePolicyResponse.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_POLICY_FIELD, REVISION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutResourcePolicyResponse.memberNameToFieldInitializer();
    private final ResourcePolicy resourcePolicy;
    private final String revisionId;

    private PutResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.resourcePolicy = builder.resourcePolicy;
        this.revisionId = builder.revisionId;
    }

    public final ResourcePolicy resourcePolicy() {
        return this.resourcePolicy;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyResponse)) {
            return false;
        }
        PutResourcePolicyResponse other = (PutResourcePolicyResponse)((Object)obj);
        return Objects.equals(this.resourcePolicy(), other.resourcePolicy()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public final String toString() {
        return ToString.builder((String)"PutResourcePolicyResponse").add("ResourcePolicy", (Object)this.resourcePolicy()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourcePolicy": {
                return Optional.ofNullable(clazz.cast(this.resourcePolicy()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourcePolicy", RESOURCE_POLICY_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyResponse, T> g) {
        return obj -> g.apply((PutResourcePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private ResourcePolicy resourcePolicy;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyResponse model) {
            super(model);
            this.resourcePolicy(model.resourcePolicy);
            this.revisionId(model.revisionId);
        }

        public final ResourcePolicy.Builder getResourcePolicy() {
            return this.resourcePolicy != null ? this.resourcePolicy.toBuilder() : null;
        }

        public final void setResourcePolicy(ResourcePolicy.BuilderImpl resourcePolicy) {
            this.resourcePolicy = resourcePolicy != null ? resourcePolicy.build() : null;
        }

        @Override
        public final Builder resourcePolicy(ResourcePolicy resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public PutResourcePolicyResponse build() {
            return new PutResourcePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutResourcePolicyResponse> {
        public Builder resourcePolicy(ResourcePolicy var1);

        default public Builder resourcePolicy(Consumer<ResourcePolicy.Builder> resourcePolicy) {
            return this.resourcePolicy((ResourcePolicy)((ResourcePolicy.Builder)ResourcePolicy.builder().applyMutation(resourcePolicy)).build());
        }

        public Builder revisionId(String var1);
    }
}

