/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParseKeyValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParseKeyValue> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(ParseKeyValue.getter(ParseKeyValue::source)).setter(ParseKeyValue.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destination").getter(ParseKeyValue.getter(ParseKeyValue::destination)).setter(ParseKeyValue.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> FIELD_DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldDelimiter").getter(ParseKeyValue.getter(ParseKeyValue::fieldDelimiter)).setter(ParseKeyValue.setter(Builder::fieldDelimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldDelimiter").build()}).build();
    private static final SdkField<String> KEY_VALUE_DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyValueDelimiter").getter(ParseKeyValue.getter(ParseKeyValue::keyValueDelimiter)).setter(ParseKeyValue.setter(Builder::keyValueDelimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValueDelimiter").build()}).build();
    private static final SdkField<String> KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyPrefix").getter(ParseKeyValue.getter(ParseKeyValue::keyPrefix)).setter(ParseKeyValue.setter(Builder::keyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPrefix").build()}).build();
    private static final SdkField<String> NON_MATCH_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nonMatchValue").getter(ParseKeyValue.getter(ParseKeyValue::nonMatchValue)).setter(ParseKeyValue.setter(Builder::nonMatchValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonMatchValue").build()}).build();
    private static final SdkField<Boolean> OVERWRITE_IF_EXISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("overwriteIfExists").getter(ParseKeyValue.getter(ParseKeyValue::overwriteIfExists)).setter(ParseKeyValue.setter(Builder::overwriteIfExists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overwriteIfExists").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, DESTINATION_FIELD, FIELD_DELIMITER_FIELD, KEY_VALUE_DELIMITER_FIELD, KEY_PREFIX_FIELD, NON_MATCH_VALUE_FIELD, OVERWRITE_IF_EXISTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParseKeyValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String source;
    private final String destination;
    private final String fieldDelimiter;
    private final String keyValueDelimiter;
    private final String keyPrefix;
    private final String nonMatchValue;
    private final Boolean overwriteIfExists;

    private ParseKeyValue(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.fieldDelimiter = builder.fieldDelimiter;
        this.keyValueDelimiter = builder.keyValueDelimiter;
        this.keyPrefix = builder.keyPrefix;
        this.nonMatchValue = builder.nonMatchValue;
        this.overwriteIfExists = builder.overwriteIfExists;
    }

    public final String source() {
        return this.source;
    }

    public final String destination() {
        return this.destination;
    }

    public final String fieldDelimiter() {
        return this.fieldDelimiter;
    }

    public final String keyValueDelimiter() {
        return this.keyValueDelimiter;
    }

    public final String keyPrefix() {
        return this.keyPrefix;
    }

    public final String nonMatchValue() {
        return this.nonMatchValue;
    }

    public final Boolean overwriteIfExists() {
        return this.overwriteIfExists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValueDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonMatchValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.overwriteIfExists());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParseKeyValue)) {
            return false;
        }
        ParseKeyValue other = (ParseKeyValue)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.fieldDelimiter(), other.fieldDelimiter()) && Objects.equals(this.keyValueDelimiter(), other.keyValueDelimiter()) && Objects.equals(this.keyPrefix(), other.keyPrefix()) && Objects.equals(this.nonMatchValue(), other.nonMatchValue()) && Objects.equals(this.overwriteIfExists(), other.overwriteIfExists());
    }

    public final String toString() {
        return ToString.builder((String)"ParseKeyValue").add("Source", (Object)this.source()).add("Destination", (Object)this.destination()).add("FieldDelimiter", (Object)this.fieldDelimiter()).add("KeyValueDelimiter", (Object)this.keyValueDelimiter()).add("KeyPrefix", (Object)this.keyPrefix()).add("NonMatchValue", (Object)this.nonMatchValue()).add("OverwriteIfExists", (Object)this.overwriteIfExists()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "fieldDelimiter": {
                return Optional.ofNullable(clazz.cast(this.fieldDelimiter()));
            }
            case "keyValueDelimiter": {
                return Optional.ofNullable(clazz.cast(this.keyValueDelimiter()));
            }
            case "keyPrefix": {
                return Optional.ofNullable(clazz.cast(this.keyPrefix()));
            }
            case "nonMatchValue": {
                return Optional.ofNullable(clazz.cast(this.nonMatchValue()));
            }
            case "overwriteIfExists": {
                return Optional.ofNullable(clazz.cast(this.overwriteIfExists()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("source", SOURCE_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("fieldDelimiter", FIELD_DELIMITER_FIELD);
        map.put("keyValueDelimiter", KEY_VALUE_DELIMITER_FIELD);
        map.put("keyPrefix", KEY_PREFIX_FIELD);
        map.put("nonMatchValue", NON_MATCH_VALUE_FIELD);
        map.put("overwriteIfExists", OVERWRITE_IF_EXISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParseKeyValue, T> g) {
        return obj -> g.apply((ParseKeyValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private String destination;
        private String fieldDelimiter;
        private String keyValueDelimiter;
        private String keyPrefix;
        private String nonMatchValue;
        private Boolean overwriteIfExists;

        private BuilderImpl() {
        }

        private BuilderImpl(ParseKeyValue model) {
            this.source(model.source);
            this.destination(model.destination);
            this.fieldDelimiter(model.fieldDelimiter);
            this.keyValueDelimiter(model.keyValueDelimiter);
            this.keyPrefix(model.keyPrefix);
            this.nonMatchValue(model.nonMatchValue);
            this.overwriteIfExists(model.overwriteIfExists);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getFieldDelimiter() {
            return this.fieldDelimiter;
        }

        public final void setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
        }

        @Override
        public final Builder fieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public final String getKeyValueDelimiter() {
            return this.keyValueDelimiter;
        }

        public final void setKeyValueDelimiter(String keyValueDelimiter) {
            this.keyValueDelimiter = keyValueDelimiter;
        }

        @Override
        public final Builder keyValueDelimiter(String keyValueDelimiter) {
            this.keyValueDelimiter = keyValueDelimiter;
            return this;
        }

        public final String getKeyPrefix() {
            return this.keyPrefix;
        }

        public final void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        @Override
        public final Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public final String getNonMatchValue() {
            return this.nonMatchValue;
        }

        public final void setNonMatchValue(String nonMatchValue) {
            this.nonMatchValue = nonMatchValue;
        }

        @Override
        public final Builder nonMatchValue(String nonMatchValue) {
            this.nonMatchValue = nonMatchValue;
            return this;
        }

        public final Boolean getOverwriteIfExists() {
            return this.overwriteIfExists;
        }

        public final void setOverwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
        }

        @Override
        public final Builder overwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        public ParseKeyValue build() {
            return new ParseKeyValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParseKeyValue> {
        public Builder source(String var1);

        public Builder destination(String var1);

        public Builder fieldDelimiter(String var1);

        public Builder keyValueDelimiter(String var1);

        public Builder keyPrefix(String var1);

        public Builder nonMatchValue(String var1);

        public Builder overwriteIfExists(Boolean var1);
    }
}

