/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.IntegrationStatus;
import software.amazon.awssdk.services.cloudwatchlogs.model.IntegrationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIntegrationsRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, ListIntegrationsRequest> {
    private static final SdkField<String> INTEGRATION_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationNamePrefix").getter(ListIntegrationsRequest.getter(ListIntegrationsRequest::integrationNamePrefix)).setter(ListIntegrationsRequest.setter(Builder::integrationNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationNamePrefix").build()}).build();
    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationType").getter(ListIntegrationsRequest.getter(ListIntegrationsRequest::integrationTypeAsString)).setter(ListIntegrationsRequest.setter(Builder::integrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationType").build()}).build();
    private static final SdkField<String> INTEGRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationStatus").getter(ListIntegrationsRequest.getter(ListIntegrationsRequest::integrationStatusAsString)).setter(ListIntegrationsRequest.setter(Builder::integrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_NAME_PREFIX_FIELD, INTEGRATION_TYPE_FIELD, INTEGRATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIntegrationsRequest.memberNameToFieldInitializer();
    private final String integrationNamePrefix;
    private final String integrationType;
    private final String integrationStatus;

    private ListIntegrationsRequest(BuilderImpl builder) {
        super(builder);
        this.integrationNamePrefix = builder.integrationNamePrefix;
        this.integrationType = builder.integrationType;
        this.integrationStatus = builder.integrationStatus;
    }

    public final String integrationNamePrefix() {
        return this.integrationNamePrefix;
    }

    public final IntegrationType integrationType() {
        return IntegrationType.fromValue(this.integrationType);
    }

    public final String integrationTypeAsString() {
        return this.integrationType;
    }

    public final IntegrationStatus integrationStatus() {
        return IntegrationStatus.fromValue(this.integrationStatus);
    }

    public final String integrationStatusAsString() {
        return this.integrationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntegrationsRequest)) {
            return false;
        }
        ListIntegrationsRequest other = (ListIntegrationsRequest)((Object)obj);
        return Objects.equals(this.integrationNamePrefix(), other.integrationNamePrefix()) && Objects.equals(this.integrationTypeAsString(), other.integrationTypeAsString()) && Objects.equals(this.integrationStatusAsString(), other.integrationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListIntegrationsRequest").add("IntegrationNamePrefix", (Object)this.integrationNamePrefix()).add("IntegrationType", (Object)this.integrationTypeAsString()).add("IntegrationStatus", (Object)this.integrationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "integrationNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.integrationNamePrefix()));
            }
            case "integrationType": {
                return Optional.ofNullable(clazz.cast(this.integrationTypeAsString()));
            }
            case "integrationStatus": {
                return Optional.ofNullable(clazz.cast(this.integrationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("integrationNamePrefix", INTEGRATION_NAME_PREFIX_FIELD);
        map.put("integrationType", INTEGRATION_TYPE_FIELD);
        map.put("integrationStatus", INTEGRATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIntegrationsRequest, T> g) {
        return obj -> g.apply((ListIntegrationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String integrationNamePrefix;
        private String integrationType;
        private String integrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntegrationsRequest model) {
            super(model);
            this.integrationNamePrefix(model.integrationNamePrefix);
            this.integrationType(model.integrationType);
            this.integrationStatus(model.integrationStatus);
        }

        public final String getIntegrationNamePrefix() {
            return this.integrationNamePrefix;
        }

        public final void setIntegrationNamePrefix(String integrationNamePrefix) {
            this.integrationNamePrefix = integrationNamePrefix;
        }

        @Override
        public final Builder integrationNamePrefix(String integrationNamePrefix) {
            this.integrationNamePrefix = integrationNamePrefix;
            return this;
        }

        public final String getIntegrationType() {
            return this.integrationType;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        public final String getIntegrationStatus() {
            return this.integrationStatus;
        }

        public final void setIntegrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
        }

        @Override
        public final Builder integrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
            return this;
        }

        @Override
        public final Builder integrationStatus(IntegrationStatus integrationStatus) {
            this.integrationStatus(integrationStatus == null ? null : integrationStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIntegrationsRequest build() {
            return new ListIntegrationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIntegrationsRequest> {
        public Builder integrationNamePrefix(String var1);

        public Builder integrationType(String var1);

        public Builder integrationType(IntegrationType var1);

        public Builder integrationStatus(String var1);

        public Builder integrationStatus(IntegrationStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

