/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogStreamNamesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartLiveTailLogGroupIdentifiersCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartLiveTailResponseHandler;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartLiveTailResponseStream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LiveTailSessionStart
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LiveTailSessionStart>,
StartLiveTailResponseStream {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(LiveTailSessionStart.getter(LiveTailSessionStart::requestId)).setter(LiveTailSessionStart.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(LiveTailSessionStart.getter(LiveTailSessionStart::sessionId)).setter(LiveTailSessionStart.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<List<String>> LOG_GROUP_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroupIdentifiers").getter(LiveTailSessionStart.getter(LiveTailSessionStart::logGroupIdentifiers)).setter(LiveTailSessionStart.setter(Builder::logGroupIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOG_STREAM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logStreamNames").getter(LiveTailSessionStart.getter(LiveTailSessionStart::logStreamNames)).setter(LiveTailSessionStart.setter(Builder::logStreamNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOG_STREAM_NAME_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logStreamNamePrefixes").getter(LiveTailSessionStart.getter(LiveTailSessionStart::logStreamNamePrefixes)).setter(LiveTailSessionStart.setter(Builder::logStreamNamePrefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNamePrefixes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOG_EVENT_FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logEventFilterPattern").getter(LiveTailSessionStart.getter(LiveTailSessionStart::logEventFilterPattern)).setter(LiveTailSessionStart.setter(Builder::logEventFilterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logEventFilterPattern").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, SESSION_ID_FIELD, LOG_GROUP_IDENTIFIERS_FIELD, LOG_STREAM_NAMES_FIELD, LOG_STREAM_NAME_PREFIXES_FIELD, LOG_EVENT_FILTER_PATTERN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LiveTailSessionStart.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String requestIdValue;
    private final String sessionId;
    private final List<String> logGroupIdentifiers;
    private final List<String> logStreamNames;
    private final List<String> logStreamNamePrefixes;
    private final String logEventFilterPattern;

    protected LiveTailSessionStart(BuilderImpl builder) {
        this.requestIdValue = builder.requestIdValue;
        this.sessionId = builder.sessionId;
        this.logGroupIdentifiers = builder.logGroupIdentifiers;
        this.logStreamNames = builder.logStreamNames;
        this.logStreamNamePrefixes = builder.logStreamNamePrefixes;
        this.logEventFilterPattern = builder.logEventFilterPattern;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final boolean hasLogGroupIdentifiers() {
        return this.logGroupIdentifiers != null && !(this.logGroupIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> logGroupIdentifiers() {
        return this.logGroupIdentifiers;
    }

    public final boolean hasLogStreamNames() {
        return this.logStreamNames != null && !(this.logStreamNames instanceof SdkAutoConstructList);
    }

    public final List<String> logStreamNames() {
        return this.logStreamNames;
    }

    public final boolean hasLogStreamNamePrefixes() {
        return this.logStreamNamePrefixes != null && !(this.logStreamNamePrefixes instanceof SdkAutoConstructList);
    }

    public final List<String> logStreamNamePrefixes() {
        return this.logStreamNamePrefixes;
    }

    public final String logEventFilterPattern() {
        return this.logEventFilterPattern;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroupIdentifiers() ? this.logGroupIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogStreamNames() ? this.logStreamNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogStreamNamePrefixes() ? this.logStreamNamePrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logEventFilterPattern());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveTailSessionStart)) {
            return false;
        }
        LiveTailSessionStart other = (LiveTailSessionStart)obj;
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.sessionId(), other.sessionId()) && this.hasLogGroupIdentifiers() == other.hasLogGroupIdentifiers() && Objects.equals(this.logGroupIdentifiers(), other.logGroupIdentifiers()) && this.hasLogStreamNames() == other.hasLogStreamNames() && Objects.equals(this.logStreamNames(), other.logStreamNames()) && this.hasLogStreamNamePrefixes() == other.hasLogStreamNamePrefixes() && Objects.equals(this.logStreamNamePrefixes(), other.logStreamNamePrefixes()) && Objects.equals(this.logEventFilterPattern(), other.logEventFilterPattern());
    }

    public final String toString() {
        return ToString.builder((String)"LiveTailSessionStart").add("RequestId", (Object)this.requestId()).add("SessionId", (Object)this.sessionId()).add("LogGroupIdentifiers", this.hasLogGroupIdentifiers() ? this.logGroupIdentifiers() : null).add("LogStreamNames", this.hasLogStreamNames() ? this.logStreamNames() : null).add("LogStreamNamePrefixes", this.hasLogStreamNamePrefixes() ? this.logStreamNamePrefixes() : null).add("LogEventFilterPattern", (Object)this.logEventFilterPattern()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "logGroupIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.logGroupIdentifiers()));
            }
            case "logStreamNames": {
                return Optional.ofNullable(clazz.cast(this.logStreamNames()));
            }
            case "logStreamNamePrefixes": {
                return Optional.ofNullable(clazz.cast(this.logStreamNamePrefixes()));
            }
            case "logEventFilterPattern": {
                return Optional.ofNullable(clazz.cast(this.logEventFilterPattern()));
            }
        }
        return Optional.empty();
    }

    public final LiveTailSessionStart copy(Consumer<? super Builder> modifier) {
        return (LiveTailSessionStart)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("logGroupIdentifiers", LOG_GROUP_IDENTIFIERS_FIELD);
        map.put("logStreamNames", LOG_STREAM_NAMES_FIELD);
        map.put("logStreamNamePrefixes", LOG_STREAM_NAME_PREFIXES_FIELD);
        map.put("logEventFilterPattern", LOG_EVENT_FILTER_PATTERN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LiveTailSessionStart, T> g) {
        return obj -> g.apply((LiveTailSessionStart)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(StartLiveTailResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String sessionId;
        private List<String> logGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> logStreamNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> logStreamNamePrefixes = DefaultSdkAutoConstructList.getInstance();
        private String logEventFilterPattern;

        protected BuilderImpl() {
        }

        protected BuilderImpl(LiveTailSessionStart model) {
            this.requestId(model.requestIdValue);
            this.sessionId(model.sessionId);
            this.logGroupIdentifiers(model.logGroupIdentifiers);
            this.logStreamNames(model.logStreamNames);
            this.logStreamNamePrefixes(model.logStreamNamePrefixes);
            this.logEventFilterPattern(model.logEventFilterPattern);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Collection<String> getLogGroupIdentifiers() {
            if (this.logGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logGroupIdentifiers;
        }

        public final void setLogGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = StartLiveTailLogGroupIdentifiersCopier.copy(logGroupIdentifiers);
        }

        @Override
        public final Builder logGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = StartLiveTailLogGroupIdentifiersCopier.copy(logGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupIdentifiers(String ... logGroupIdentifiers) {
            this.logGroupIdentifiers(Arrays.asList(logGroupIdentifiers));
            return this;
        }

        public final Collection<String> getLogStreamNames() {
            if (this.logStreamNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logStreamNames;
        }

        public final void setLogStreamNames(Collection<String> logStreamNames) {
            this.logStreamNames = InputLogStreamNamesCopier.copy(logStreamNames);
        }

        @Override
        public final Builder logStreamNames(Collection<String> logStreamNames) {
            this.logStreamNames = InputLogStreamNamesCopier.copy(logStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreamNames(String ... logStreamNames) {
            this.logStreamNames(Arrays.asList(logStreamNames));
            return this;
        }

        public final Collection<String> getLogStreamNamePrefixes() {
            if (this.logStreamNamePrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logStreamNamePrefixes;
        }

        public final void setLogStreamNamePrefixes(Collection<String> logStreamNamePrefixes) {
            this.logStreamNamePrefixes = InputLogStreamNamesCopier.copy(logStreamNamePrefixes);
        }

        @Override
        public final Builder logStreamNamePrefixes(Collection<String> logStreamNamePrefixes) {
            this.logStreamNamePrefixes = InputLogStreamNamesCopier.copy(logStreamNamePrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreamNamePrefixes(String ... logStreamNamePrefixes) {
            this.logStreamNamePrefixes(Arrays.asList(logStreamNamePrefixes));
            return this;
        }

        public final String getLogEventFilterPattern() {
            return this.logEventFilterPattern;
        }

        public final void setLogEventFilterPattern(String logEventFilterPattern) {
            this.logEventFilterPattern = logEventFilterPattern;
        }

        @Override
        public final Builder logEventFilterPattern(String logEventFilterPattern) {
            this.logEventFilterPattern = logEventFilterPattern;
            return this;
        }

        public LiveTailSessionStart build() {
            return new LiveTailSessionStart(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LiveTailSessionStart> {
        public Builder requestId(String var1);

        public Builder sessionId(String var1);

        public Builder logGroupIdentifiers(Collection<String> var1);

        public Builder logGroupIdentifiers(String ... var1);

        public Builder logStreamNames(Collection<String> var1);

        public Builder logStreamNames(String ... var1);

        public Builder logStreamNamePrefixes(Collection<String> var1);

        public Builder logStreamNamePrefixes(String ... var1);

        public Builder logEventFilterPattern(String var1);
    }
}

