/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.SubscriptionFilter;

public class DescribeSubscriptionFiltersPublisher
implements SdkPublisher<DescribeSubscriptionFiltersResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final DescribeSubscriptionFiltersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSubscriptionFiltersPublisher(CloudWatchLogsAsyncClient client, DescribeSubscriptionFiltersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSubscriptionFiltersPublisher(CloudWatchLogsAsyncClient client, DescribeSubscriptionFiltersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSubscriptionFiltersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSubscriptionFiltersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SubscriptionFilter> subscriptionFilters() {
        Function<DescribeSubscriptionFiltersResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptionFilters() != null) {
                return response.subscriptionFilters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSubscriptionFiltersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSubscriptionFiltersResponseFetcher
    implements AsyncPageFetcher<DescribeSubscriptionFiltersResponse> {
        private DescribeSubscriptionFiltersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSubscriptionFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSubscriptionFiltersResponse> nextPage(DescribeSubscriptionFiltersResponse previousPage) {
            if (previousPage == null) {
                return DescribeSubscriptionFiltersPublisher.this.client.describeSubscriptionFilters(DescribeSubscriptionFiltersPublisher.this.firstRequest);
            }
            return DescribeSubscriptionFiltersPublisher.this.client.describeSubscriptionFilters((DescribeSubscriptionFiltersRequest)((Object)DescribeSubscriptionFiltersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

