/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliveryDestination;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliveryDestinationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeliveryDestinationsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeDeliveryDestinationsResponse> {
    private static final SdkField<List<DeliveryDestination>> DELIVERY_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deliveryDestinations").getter(DescribeDeliveryDestinationsResponse.getter(DescribeDeliveryDestinationsResponse::deliveryDestinations)).setter(DescribeDeliveryDestinationsResponse.setter(Builder::deliveryDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeliveryDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeDeliveryDestinationsResponse.getter(DescribeDeliveryDestinationsResponse::nextToken)).setter(DescribeDeliveryDestinationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_DESTINATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDeliveryDestinationsResponse.memberNameToFieldInitializer();
    private final List<DeliveryDestination> deliveryDestinations;
    private final String nextToken;

    private DescribeDeliveryDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryDestinations = builder.deliveryDestinations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDeliveryDestinations() {
        return this.deliveryDestinations != null && !(this.deliveryDestinations instanceof SdkAutoConstructList);
    }

    public final List<DeliveryDestination> deliveryDestinations() {
        return this.deliveryDestinations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeliveryDestinations() ? this.deliveryDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryDestinationsResponse)) {
            return false;
        }
        DescribeDeliveryDestinationsResponse other = (DescribeDeliveryDestinationsResponse)((Object)obj);
        return this.hasDeliveryDestinations() == other.hasDeliveryDestinations() && Objects.equals(this.deliveryDestinations(), other.deliveryDestinations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeliveryDestinationsResponse").add("DeliveryDestinations", this.hasDeliveryDestinations() ? this.deliveryDestinations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deliveryDestinations": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deliveryDestinations", DELIVERY_DESTINATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeliveryDestinationsResponse, T> g) {
        return obj -> g.apply((DescribeDeliveryDestinationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<DeliveryDestination> deliveryDestinations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryDestinationsResponse model) {
            super(model);
            this.deliveryDestinations(model.deliveryDestinations);
            this.nextToken(model.nextToken);
        }

        public final List<DeliveryDestination.Builder> getDeliveryDestinations() {
            List<DeliveryDestination.Builder> result = DeliveryDestinationsCopier.copyToBuilder(this.deliveryDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeliveryDestinations(Collection<DeliveryDestination.BuilderImpl> deliveryDestinations) {
            this.deliveryDestinations = DeliveryDestinationsCopier.copyFromBuilder(deliveryDestinations);
        }

        @Override
        public final Builder deliveryDestinations(Collection<DeliveryDestination> deliveryDestinations) {
            this.deliveryDestinations = DeliveryDestinationsCopier.copy(deliveryDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryDestinations(DeliveryDestination ... deliveryDestinations) {
            this.deliveryDestinations(Arrays.asList(deliveryDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryDestinations(Consumer<DeliveryDestination.Builder> ... deliveryDestinations) {
            this.deliveryDestinations(Stream.of(deliveryDestinations).map(c -> (DeliveryDestination)((DeliveryDestination.Builder)DeliveryDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDeliveryDestinationsResponse build() {
            return new DescribeDeliveryDestinationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeliveryDestinationsResponse> {
        public Builder deliveryDestinations(Collection<DeliveryDestination> var1);

        public Builder deliveryDestinations(DeliveryDestination ... var1);

        public Builder deliveryDestinations(Consumer<DeliveryDestination.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

