/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cloudwatchevents.CloudWatchEventsClient;
import software.amazon.awssdk.services.cloudwatchevents.CloudWatchEventsServiceClientConfiguration;
import software.amazon.awssdk.services.cloudwatchevents.internal.CloudWatchEventsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudwatchevents.model.ActivateEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ActivateEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.CancelReplayRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.CancelReplayResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsException;
import software.amazon.awssdk.services.cloudwatchevents.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudwatchevents.model.CreateApiDestinationRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.CreateApiDestinationResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.CreateArchiveRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.CreateArchiveResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.CreateConnectionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.CreateConnectionResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.CreateEventBusRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.CreateEventBusResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.CreatePartnerEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.CreatePartnerEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeactivateEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeactivateEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeauthorizeConnectionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeauthorizeConnectionResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteApiDestinationRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteApiDestinationResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteArchiveRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteArchiveResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteEventBusRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteEventBusResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeletePartnerEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeletePartnerEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeApiDestinationRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeApiDestinationResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeArchiveRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeArchiveResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeConnectionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeConnectionResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventBusRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventBusResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribePartnerEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribePartnerEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeReplayRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeReplayResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DisableRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DisableRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.EnableRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.EnableRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.IllegalStatusException;
import software.amazon.awssdk.services.cloudwatchevents.model.InternalException;
import software.amazon.awssdk.services.cloudwatchevents.model.InvalidEventPatternException;
import software.amazon.awssdk.services.cloudwatchevents.model.InvalidStateException;
import software.amazon.awssdk.services.cloudwatchevents.model.LimitExceededException;
import software.amazon.awssdk.services.cloudwatchevents.model.ListApiDestinationsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListApiDestinationsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListArchivesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListArchivesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListConnectionsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListConnectionsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListEventBusesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListEventBusesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListEventSourcesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListEventSourcesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListPartnerEventSourceAccountsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListPartnerEventSourceAccountsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListPartnerEventSourcesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListPartnerEventSourcesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListReplaysRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListReplaysResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRuleNamesByTargetRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRuleNamesByTargetResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRulesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRulesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTargetsByRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTargetsByRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ManagedRuleException;
import software.amazon.awssdk.services.cloudwatchevents.model.OperationDisabledException;
import software.amazon.awssdk.services.cloudwatchevents.model.PolicyLengthExceededException;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPartnerEventsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPartnerEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPermissionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPermissionResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutTargetsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutTargetsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.RemovePermissionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.RemovePermissionResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.RemoveTargetsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.RemoveTargetsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.cloudwatchevents.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudwatchevents.model.StartReplayRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.StartReplayResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.TestEventPatternRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.TestEventPatternResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.UpdateApiDestinationRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.UpdateApiDestinationResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.UpdateArchiveRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.UpdateArchiveResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.cloudwatchevents.transform.ActivateEventSourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.CancelReplayRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.CreateApiDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.CreateArchiveRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.CreateConnectionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.CreateEventBusRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.CreatePartnerEventSourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeactivateEventSourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeauthorizeConnectionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeleteApiDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeleteArchiveRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeleteEventBusRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeletePartnerEventSourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribeApiDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribeArchiveRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribeConnectionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribeEventBusRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribeEventSourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribePartnerEventSourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribeReplayRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribeRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DisableRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.EnableRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListApiDestinationsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListArchivesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListConnectionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListEventBusesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListEventSourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListPartnerEventSourceAccountsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListPartnerEventSourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListReplaysRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListRuleNamesByTargetRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListTargetsByRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutPartnerEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutPermissionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutTargetsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.RemoveTargetsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.StartReplayRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.TestEventPatternRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.UpdateApiDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.UpdateArchiveRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.UpdateConnectionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCloudWatchEventsClient
implements CloudWatchEventsClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudWatchEventsClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudWatchEventsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CloudWatch_Events#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivateEventSourceResponse activateEventSource(ActivateEventSourceRequest activateEventSourceRequest) throws ResourceNotFoundException, ConcurrentModificationException, InvalidStateException, InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ActivateEventSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)activateEventSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, activateEventSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ActivateEventSource");
            ActivateEventSourceResponse activateEventSourceResponse = (ActivateEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ActivateEventSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)activateEventSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ActivateEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return activateEventSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$activateEventSource$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelReplayResponse cancelReplay(CancelReplayRequest cancelReplayRequest) throws ResourceNotFoundException, ConcurrentModificationException, IllegalStatusException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelReplayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelReplayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, cancelReplayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelReplay");
            CancelReplayResponse cancelReplayResponse = (CancelReplayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelReplay").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelReplayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelReplayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelReplayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$cancelReplay$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApiDestinationResponse createApiDestination(CreateApiDestinationRequest createApiDestinationRequest) throws ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApiDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createApiDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, createApiDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApiDestination");
            CreateApiDestinationResponse createApiDestinationResponse = (CreateApiDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApiDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createApiDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateApiDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApiDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$createApiDestination$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateArchiveResponse createArchive(CreateArchiveRequest createArchiveRequest) throws ConcurrentModificationException, ResourceAlreadyExistsException, ResourceNotFoundException, InternalException, LimitExceededException, InvalidEventPatternException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateArchiveResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createArchiveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, createArchiveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateArchive");
            CreateArchiveResponse createArchiveResponse = (CreateArchiveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateArchive").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createArchiveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateArchiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createArchiveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$createArchive$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest createConnectionRequest) throws ResourceAlreadyExistsException, LimitExceededException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, createConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConnection");
            CreateConnectionResponse createConnectionResponse = (CreateConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$createConnection$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEventBusResponse createEventBus(CreateEventBusRequest createEventBusRequest) throws ResourceAlreadyExistsException, ResourceNotFoundException, InvalidStateException, InternalException, ConcurrentModificationException, LimitExceededException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventBusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEventBusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, createEventBusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventBus");
            CreateEventBusResponse createEventBusResponse = (CreateEventBusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventBus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEventBusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEventBusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEventBusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$createEventBus$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePartnerEventSourceResponse createPartnerEventSource(CreatePartnerEventSourceRequest createPartnerEventSourceRequest) throws ResourceAlreadyExistsException, InternalException, ConcurrentModificationException, LimitExceededException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePartnerEventSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPartnerEventSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, createPartnerEventSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePartnerEventSource");
            CreatePartnerEventSourceResponse createPartnerEventSourceResponse = (CreatePartnerEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePartnerEventSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPartnerEventSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePartnerEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPartnerEventSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$createPartnerEventSource$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeactivateEventSourceResponse deactivateEventSource(DeactivateEventSourceRequest deactivateEventSourceRequest) throws ResourceNotFoundException, ConcurrentModificationException, InvalidStateException, InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeactivateEventSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deactivateEventSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, deactivateEventSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeactivateEventSource");
            DeactivateEventSourceResponse deactivateEventSourceResponse = (DeactivateEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeactivateEventSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deactivateEventSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeactivateEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deactivateEventSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$deactivateEventSource$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeauthorizeConnectionResponse deauthorizeConnection(DeauthorizeConnectionRequest deauthorizeConnectionRequest) throws ConcurrentModificationException, ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeauthorizeConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deauthorizeConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, deauthorizeConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeauthorizeConnection");
            DeauthorizeConnectionResponse deauthorizeConnectionResponse = (DeauthorizeConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeauthorizeConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deauthorizeConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeauthorizeConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deauthorizeConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$deauthorizeConnection$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApiDestinationResponse deleteApiDestination(DeleteApiDestinationRequest deleteApiDestinationRequest) throws ConcurrentModificationException, ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApiDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApiDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, deleteApiDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApiDestination");
            DeleteApiDestinationResponse deleteApiDestinationResponse = (DeleteApiDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApiDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteApiDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApiDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApiDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$deleteApiDestination$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteArchiveResponse deleteArchive(DeleteArchiveRequest deleteArchiveRequest) throws ConcurrentModificationException, ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteArchiveResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteArchiveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, deleteArchiveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteArchive");
            DeleteArchiveResponse deleteArchiveResponse = (DeleteArchiveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteArchive").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteArchiveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteArchiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteArchiveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$deleteArchive$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest) throws ConcurrentModificationException, ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, deleteConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnection");
            DeleteConnectionResponse deleteConnectionResponse = (DeleteConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$deleteConnection$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventBusResponse deleteEventBus(DeleteEventBusRequest deleteEventBusRequest) throws InternalException, ConcurrentModificationException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventBusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEventBusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, deleteEventBusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventBus");
            DeleteEventBusResponse deleteEventBusResponse = (DeleteEventBusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventBus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEventBusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEventBusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEventBusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$deleteEventBus$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePartnerEventSourceResponse deletePartnerEventSource(DeletePartnerEventSourceRequest deletePartnerEventSourceRequest) throws InternalException, ConcurrentModificationException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePartnerEventSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePartnerEventSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, deletePartnerEventSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePartnerEventSource");
            DeletePartnerEventSourceResponse deletePartnerEventSourceResponse = (DeletePartnerEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePartnerEventSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePartnerEventSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePartnerEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePartnerEventSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$deletePartnerEventSource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws ConcurrentModificationException, ManagedRuleException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, deleteRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRule");
            DeleteRuleResponse deleteRuleResponse = (DeleteRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$deleteRule$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApiDestinationResponse describeApiDestination(DescribeApiDestinationRequest describeApiDestinationRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApiDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeApiDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, describeApiDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApiDestination");
            DescribeApiDestinationResponse describeApiDestinationResponse = (DescribeApiDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApiDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeApiDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeApiDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeApiDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$describeApiDestination$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeArchiveResponse describeArchive(DescribeArchiveRequest describeArchiveRequest) throws ResourceAlreadyExistsException, ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeArchiveResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeArchiveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, describeArchiveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeArchive");
            DescribeArchiveResponse describeArchiveResponse = (DescribeArchiveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeArchive").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeArchiveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeArchiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeArchiveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$describeArchive$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionResponse describeConnection(DescribeConnectionRequest describeConnectionRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, describeConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnection");
            DescribeConnectionResponse describeConnectionResponse = (DescribeConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$describeConnection$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventBusResponse describeEventBus(DescribeEventBusRequest describeEventBusRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventBusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventBusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, describeEventBusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventBus");
            DescribeEventBusResponse describeEventBusResponse = (DescribeEventBusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventBus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEventBusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventBusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventBusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$describeEventBus$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventSourceResponse describeEventSource(DescribeEventSourceRequest describeEventSourceRequest) throws ResourceNotFoundException, InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, describeEventSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventSource");
            DescribeEventSourceResponse describeEventSourceResponse = (DescribeEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEventSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$describeEventSource$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePartnerEventSourceResponse describePartnerEventSource(DescribePartnerEventSourceRequest describePartnerEventSourceRequest) throws ResourceNotFoundException, InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePartnerEventSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePartnerEventSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, describePartnerEventSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePartnerEventSource");
            DescribePartnerEventSourceResponse describePartnerEventSourceResponse = (DescribePartnerEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePartnerEventSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describePartnerEventSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePartnerEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePartnerEventSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$describePartnerEventSource$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplayResponse describeReplay(DescribeReplayRequest describeReplayRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReplayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, describeReplayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplay");
            DescribeReplayResponse describeReplayResponse = (DescribeReplayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplay").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReplayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$describeReplay$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRuleResponse describeRule(DescribeRuleRequest describeRuleRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, describeRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRule");
            DescribeRuleResponse describeRuleResponse = (DescribeRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$describeRule$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableRuleResponse disableRule(DisableRuleRequest disableRuleRequest) throws ResourceNotFoundException, ConcurrentModificationException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, disableRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableRule");
            DisableRuleResponse disableRuleResponse = (DisableRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$disableRule$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableRuleResponse enableRule(EnableRuleRequest enableRuleRequest) throws ResourceNotFoundException, ConcurrentModificationException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, enableRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableRule");
            EnableRuleResponse enableRuleResponse = (EnableRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$enableRule$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApiDestinationsResponse listApiDestinations(ListApiDestinationsRequest listApiDestinationsRequest) throws InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApiDestinationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApiDestinationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, listApiDestinationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApiDestinations");
            ListApiDestinationsResponse listApiDestinationsResponse = (ListApiDestinationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApiDestinations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listApiDestinationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApiDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApiDestinationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$listApiDestinations$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListArchivesResponse listArchives(ListArchivesRequest listArchivesRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListArchivesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listArchivesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, listArchivesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListArchives");
            ListArchivesResponse listArchivesResponse = (ListArchivesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListArchives").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listArchivesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListArchivesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listArchivesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$listArchives$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConnectionsResponse listConnections(ListConnectionsRequest listConnectionsRequest) throws InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConnectionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, listConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConnections");
            ListConnectionsResponse listConnectionsResponse = (ListConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConnections").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$listConnections$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventBusesResponse listEventBuses(ListEventBusesRequest listEventBusesRequest) throws InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventBusesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventBusesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, listEventBusesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventBuses");
            ListEventBusesResponse listEventBusesResponse = (ListEventBusesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventBuses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEventBusesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEventBusesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventBusesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$listEventBuses$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventSourcesResponse listEventSources(ListEventSourcesRequest listEventSourcesRequest) throws InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventSourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, listEventSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventSources");
            ListEventSourcesResponse listEventSourcesResponse = (ListEventSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventSources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEventSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEventSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$listEventSources$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPartnerEventSourceAccountsResponse listPartnerEventSourceAccounts(ListPartnerEventSourceAccountsRequest listPartnerEventSourceAccountsRequest) throws ResourceNotFoundException, InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPartnerEventSourceAccountsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPartnerEventSourceAccountsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, listPartnerEventSourceAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPartnerEventSourceAccounts");
            ListPartnerEventSourceAccountsResponse listPartnerEventSourceAccountsResponse = (ListPartnerEventSourceAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPartnerEventSourceAccounts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPartnerEventSourceAccountsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPartnerEventSourceAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPartnerEventSourceAccountsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$listPartnerEventSourceAccounts$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPartnerEventSourcesResponse listPartnerEventSources(ListPartnerEventSourcesRequest listPartnerEventSourcesRequest) throws InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPartnerEventSourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPartnerEventSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, listPartnerEventSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPartnerEventSources");
            ListPartnerEventSourcesResponse listPartnerEventSourcesResponse = (ListPartnerEventSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPartnerEventSources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPartnerEventSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPartnerEventSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPartnerEventSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$listPartnerEventSources$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReplaysResponse listReplays(ListReplaysRequest listReplaysRequest) throws InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReplaysResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReplaysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, listReplaysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReplays");
            ListReplaysResponse listReplaysResponse = (ListReplaysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReplays").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listReplaysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReplaysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReplaysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$listReplays$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRuleNamesByTargetResponse listRuleNamesByTarget(ListRuleNamesByTargetRequest listRuleNamesByTargetRequest) throws InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRuleNamesByTargetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRuleNamesByTargetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, listRuleNamesByTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRuleNamesByTarget");
            ListRuleNamesByTargetResponse listRuleNamesByTargetResponse = (ListRuleNamesByTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuleNamesByTarget").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRuleNamesByTargetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRuleNamesByTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRuleNamesByTargetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$listRuleNamesByTarget$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRulesResponse listRules(ListRulesRequest listRulesRequest) throws InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, listRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRules");
            ListRulesResponse listRulesResponse = (ListRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$listRules$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$listTagsForResource$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTargetsByRuleResponse listTargetsByRule(ListTargetsByRuleRequest listTargetsByRuleRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTargetsByRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTargetsByRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, listTargetsByRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTargetsByRule");
            ListTargetsByRuleResponse listTargetsByRuleResponse = (ListTargetsByRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTargetsByRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTargetsByRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTargetsByRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTargetsByRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$listTargetsByRule$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEventsResponse putEvents(PutEventsRequest putEventsRequest) throws InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, putEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEvents");
            PutEventsResponse putEventsResponse = (PutEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$putEvents$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPartnerEventsResponse putPartnerEvents(PutPartnerEventsRequest putPartnerEventsRequest) throws InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPartnerEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putPartnerEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, putPartnerEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPartnerEvents");
            PutPartnerEventsResponse putPartnerEventsResponse = (PutPartnerEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPartnerEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putPartnerEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutPartnerEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putPartnerEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$putPartnerEvents$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPermissionResponse putPermission(PutPermissionRequest putPermissionRequest) throws ResourceNotFoundException, PolicyLengthExceededException, InternalException, ConcurrentModificationException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putPermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, putPermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPermission");
            PutPermissionResponse putPermissionResponse = (PutPermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putPermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutPermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putPermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$putPermission$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRuleResponse putRule(PutRuleRequest putRuleRequest) throws InvalidEventPatternException, LimitExceededException, ConcurrentModificationException, ManagedRuleException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, putRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRule");
            PutRuleResponse putRuleResponse = (PutRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$putRule$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutTargetsResponse putTargets(PutTargetsRequest putTargetsRequest) throws ResourceNotFoundException, ConcurrentModificationException, LimitExceededException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutTargetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putTargetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, putTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutTargets");
            PutTargetsResponse putTargetsResponse = (PutTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutTargets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putTargetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putTargetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$putTargets$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws ResourceNotFoundException, InternalException, ConcurrentModificationException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemovePermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removePermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, removePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemovePermission");
            RemovePermissionResponse removePermissionResponse = (RemovePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemovePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removePermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemovePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removePermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$removePermission$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTargetsResponse removeTargets(RemoveTargetsRequest removeTargetsRequest) throws ResourceNotFoundException, ConcurrentModificationException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTargetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeTargetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, removeTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTargets");
            RemoveTargetsResponse removeTargetsResponse = (RemoveTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTargets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeTargetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeTargetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$removeTargets$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartReplayResponse startReplay(StartReplayRequest startReplayRequest) throws ResourceNotFoundException, ResourceAlreadyExistsException, InvalidEventPatternException, LimitExceededException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartReplayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startReplayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, startReplayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartReplay");
            StartReplayResponse startReplayResponse = (StartReplayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartReplay").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startReplayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartReplayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startReplayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$startReplay$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ConcurrentModificationException, InternalException, ManagedRuleException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$tagResource$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestEventPatternResponse testEventPattern(TestEventPatternRequest testEventPatternRequest) throws InvalidEventPatternException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestEventPatternResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)testEventPatternRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, testEventPatternRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestEventPattern");
            TestEventPatternResponse testEventPatternResponse = (TestEventPatternResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestEventPattern").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)testEventPatternRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TestEventPatternRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return testEventPatternResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$testEventPattern$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InternalException, ConcurrentModificationException, ManagedRuleException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$untagResource$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApiDestinationResponse updateApiDestination(UpdateApiDestinationRequest updateApiDestinationRequest) throws ConcurrentModificationException, ResourceNotFoundException, InternalException, LimitExceededException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApiDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApiDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, updateApiDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApiDestination");
            UpdateApiDestinationResponse updateApiDestinationResponse = (UpdateApiDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApiDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateApiDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateApiDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateApiDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$updateApiDestination$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateArchiveResponse updateArchive(UpdateArchiveRequest updateArchiveRequest) throws ConcurrentModificationException, ResourceNotFoundException, InternalException, LimitExceededException, InvalidEventPatternException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateArchiveResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateArchiveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, updateArchiveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateArchive");
            UpdateArchiveResponse updateArchiveResponse = (UpdateArchiveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateArchive").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateArchiveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateArchiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateArchiveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$updateArchive$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConnectionResponse updateConnection(UpdateConnectionRequest updateConnectionRequest) throws ConcurrentModificationException, ResourceNotFoundException, InternalException, LimitExceededException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "PolicyLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyLengthExceededException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "InvalidEventPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventPatternException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OperationDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationDisabledException::builder).build());
                }
                case "IllegalStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalStatusException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "ManagedRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ManagedRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ManagedRuleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(clientConfiguration, updateConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConnection");
            UpdateConnectionResponse updateConnectionResponse = (UpdateConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchEventsClient.lambda$updateConnection$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "events";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CloudWatchEventsServiceClientConfigurationBuilder serviceConfigBuilder = new CloudWatchEventsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudWatchEventsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final CloudWatchEventsServiceClientConfiguration serviceClientConfiguration() {
        return new CloudWatchEventsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateConnection$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateArchive$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApiDestination$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testEventPattern$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startReplay$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTargets$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removePermission$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putTargets$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRule$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPermission$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPartnerEvents$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putEvents$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTargetsByRule$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRules$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRuleNamesByTarget$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReplays$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPartnerEventSources$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPartnerEventSourceAccounts$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventSources$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventBuses$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConnections$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listArchives$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApiDestinations$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableRule$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableRule$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRule$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReplay$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePartnerEventSource$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventSource$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventBus$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnection$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeArchive$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApiDestination$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRule$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePartnerEventSource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEventBus$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnection$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteArchive$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApiDestination$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deauthorizeConnection$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deactivateEventSource$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPartnerEventSource$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEventBus$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConnection$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createArchive$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApiDestination$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelReplay$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$activateEventSource$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

