/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem;
import software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItemsCopier;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAlarmHistoryResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, DescribeAlarmHistoryResponse> {
    private static final SdkField<List<AlarmHistoryItem>> ALARM_HISTORY_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlarmHistoryItems").getter(DescribeAlarmHistoryResponse.getter(DescribeAlarmHistoryResponse::alarmHistoryItems)).setter(DescribeAlarmHistoryResponse.setter(Builder::alarmHistoryItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmHistoryItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmHistoryItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAlarmHistoryResponse.getter(DescribeAlarmHistoryResponse::nextToken)).setter(DescribeAlarmHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_HISTORY_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAlarmHistoryResponse.memberNameToFieldInitializer();
    private final List<AlarmHistoryItem> alarmHistoryItems;
    private final String nextToken;

    private DescribeAlarmHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.alarmHistoryItems = builder.alarmHistoryItems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAlarmHistoryItems() {
        return this.alarmHistoryItems != null && !(this.alarmHistoryItems instanceof SdkAutoConstructList);
    }

    public final List<AlarmHistoryItem> alarmHistoryItems() {
        return this.alarmHistoryItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmHistoryItems() ? this.alarmHistoryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmHistoryResponse)) {
            return false;
        }
        DescribeAlarmHistoryResponse other = (DescribeAlarmHistoryResponse)((Object)obj);
        return this.hasAlarmHistoryItems() == other.hasAlarmHistoryItems() && Objects.equals(this.alarmHistoryItems(), other.alarmHistoryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAlarmHistoryResponse").add("AlarmHistoryItems", this.hasAlarmHistoryItems() ? this.alarmHistoryItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmHistoryItems": {
                return Optional.ofNullable(clazz.cast(this.alarmHistoryItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AlarmHistoryItems", ALARM_HISTORY_ITEMS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmHistoryResponse, T> g) {
        return obj -> g.apply((DescribeAlarmHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<AlarmHistoryItem> alarmHistoryItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmHistoryResponse model) {
            super(model);
            this.alarmHistoryItems(model.alarmHistoryItems);
            this.nextToken(model.nextToken);
        }

        public final List<AlarmHistoryItem.Builder> getAlarmHistoryItems() {
            List<AlarmHistoryItem.Builder> result = AlarmHistoryItemsCopier.copyToBuilder(this.alarmHistoryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarmHistoryItems(Collection<AlarmHistoryItem.BuilderImpl> alarmHistoryItems) {
            this.alarmHistoryItems = AlarmHistoryItemsCopier.copyFromBuilder(alarmHistoryItems);
        }

        @Override
        public final Builder alarmHistoryItems(Collection<AlarmHistoryItem> alarmHistoryItems) {
            this.alarmHistoryItems = AlarmHistoryItemsCopier.copy(alarmHistoryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmHistoryItems(AlarmHistoryItem ... alarmHistoryItems) {
            this.alarmHistoryItems(Arrays.asList(alarmHistoryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmHistoryItems(Consumer<AlarmHistoryItem.Builder> ... alarmHistoryItems) {
            this.alarmHistoryItems(Stream.of(alarmHistoryItems).map(c -> (AlarmHistoryItem)((AlarmHistoryItem.Builder)AlarmHistoryItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAlarmHistoryResponse build() {
            return new DescribeAlarmHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAlarmHistoryResponse> {
        public Builder alarmHistoryItems(Collection<AlarmHistoryItem> var1);

        public Builder alarmHistoryItems(AlarmHistoryItem ... var1);

        public Builder alarmHistoryItems(Consumer<AlarmHistoryItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

