/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.AlarmContributor;
import software.amazon.awssdk.services.cloudwatch.model.AlarmContributorsCopier;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAlarmContributorsResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, DescribeAlarmContributorsResponse> {
    private static final SdkField<List<AlarmContributor>> ALARM_CONTRIBUTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlarmContributors").getter(DescribeAlarmContributorsResponse.getter(DescribeAlarmContributorsResponse::alarmContributors)).setter(DescribeAlarmContributorsResponse.setter(Builder::alarmContributors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmContributors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmContributor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAlarmContributorsResponse.getter(DescribeAlarmContributorsResponse::nextToken)).setter(DescribeAlarmContributorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_CONTRIBUTORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAlarmContributorsResponse.memberNameToFieldInitializer();
    private final List<AlarmContributor> alarmContributors;
    private final String nextToken;

    private DescribeAlarmContributorsResponse(BuilderImpl builder) {
        super(builder);
        this.alarmContributors = builder.alarmContributors;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAlarmContributors() {
        return this.alarmContributors != null && !(this.alarmContributors instanceof SdkAutoConstructList);
    }

    public final List<AlarmContributor> alarmContributors() {
        return this.alarmContributors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmContributors() ? this.alarmContributors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmContributorsResponse)) {
            return false;
        }
        DescribeAlarmContributorsResponse other = (DescribeAlarmContributorsResponse)((Object)obj);
        return this.hasAlarmContributors() == other.hasAlarmContributors() && Objects.equals(this.alarmContributors(), other.alarmContributors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAlarmContributorsResponse").add("AlarmContributors", this.hasAlarmContributors() ? this.alarmContributors() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmContributors": {
                return Optional.ofNullable(clazz.cast(this.alarmContributors()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AlarmContributors", ALARM_CONTRIBUTORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmContributorsResponse, T> g) {
        return obj -> g.apply((DescribeAlarmContributorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<AlarmContributor> alarmContributors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmContributorsResponse model) {
            super(model);
            this.alarmContributors(model.alarmContributors);
            this.nextToken(model.nextToken);
        }

        public final List<AlarmContributor.Builder> getAlarmContributors() {
            List<AlarmContributor.Builder> result = AlarmContributorsCopier.copyToBuilder(this.alarmContributors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarmContributors(Collection<AlarmContributor.BuilderImpl> alarmContributors) {
            this.alarmContributors = AlarmContributorsCopier.copyFromBuilder(alarmContributors);
        }

        @Override
        public final Builder alarmContributors(Collection<AlarmContributor> alarmContributors) {
            this.alarmContributors = AlarmContributorsCopier.copy(alarmContributors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmContributors(AlarmContributor ... alarmContributors) {
            this.alarmContributors(Arrays.asList(alarmContributors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmContributors(Consumer<AlarmContributor.Builder> ... alarmContributors) {
            this.alarmContributors(Stream.of(alarmContributors).map(c -> (AlarmContributor)((AlarmContributor.Builder)AlarmContributor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAlarmContributorsResponse build() {
            return new DescribeAlarmContributorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAlarmContributorsResponse> {
        public Builder alarmContributors(Collection<AlarmContributor> var1);

        public Builder alarmContributors(AlarmContributor ... var1);

        public Builder alarmContributors(Consumer<AlarmContributor.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

