/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage;
import software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDashboardResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, PutDashboardResponse> {
    private static final SdkField<List<DashboardValidationMessage>> DASHBOARD_VALIDATION_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DashboardValidationMessages").getter(PutDashboardResponse.getter(PutDashboardResponse::dashboardValidationMessages)).setter(PutDashboardResponse.setter(Builder::dashboardValidationMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardValidationMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DashboardValidationMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_VALIDATION_MESSAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DashboardValidationMessages", DASHBOARD_VALIDATION_MESSAGES_FIELD);
        }
    });
    private final List<DashboardValidationMessage> dashboardValidationMessages;

    private PutDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardValidationMessages = builder.dashboardValidationMessages;
    }

    public final boolean hasDashboardValidationMessages() {
        return this.dashboardValidationMessages != null && !(this.dashboardValidationMessages instanceof SdkAutoConstructList);
    }

    public final List<DashboardValidationMessage> dashboardValidationMessages() {
        return this.dashboardValidationMessages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashboardValidationMessages() ? this.dashboardValidationMessages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDashboardResponse)) {
            return false;
        }
        PutDashboardResponse other = (PutDashboardResponse)((Object)obj);
        return this.hasDashboardValidationMessages() == other.hasDashboardValidationMessages() && Objects.equals(this.dashboardValidationMessages(), other.dashboardValidationMessages());
    }

    public final String toString() {
        return ToString.builder((String)"PutDashboardResponse").add("DashboardValidationMessages", this.hasDashboardValidationMessages() ? this.dashboardValidationMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardValidationMessages": {
                return Optional.ofNullable(clazz.cast(this.dashboardValidationMessages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutDashboardResponse, T> g) {
        return obj -> g.apply((PutDashboardResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<DashboardValidationMessage> dashboardValidationMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutDashboardResponse model) {
            super(model);
            this.dashboardValidationMessages(model.dashboardValidationMessages);
        }

        public final List<DashboardValidationMessage.Builder> getDashboardValidationMessages() {
            List<DashboardValidationMessage.Builder> result = DashboardValidationMessagesCopier.copyToBuilder(this.dashboardValidationMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashboardValidationMessages(Collection<DashboardValidationMessage.BuilderImpl> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copyFromBuilder(dashboardValidationMessages);
        }

        @Override
        public final Builder dashboardValidationMessages(Collection<DashboardValidationMessage> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copy(dashboardValidationMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardValidationMessages(DashboardValidationMessage ... dashboardValidationMessages) {
            this.dashboardValidationMessages(Arrays.asList(dashboardValidationMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardValidationMessages(Consumer<DashboardValidationMessage.Builder> ... dashboardValidationMessages) {
            this.dashboardValidationMessages(Stream.of(dashboardValidationMessages).map(c -> (DashboardValidationMessage)((DashboardValidationMessage.Builder)DashboardValidationMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutDashboardResponse build() {
            return new PutDashboardResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDashboardResponse> {
        public Builder dashboardValidationMessages(Collection<DashboardValidationMessage> var1);

        public Builder dashboardValidationMessages(DashboardValidationMessage ... var1);

        public Builder dashboardValidationMessages(Consumer<DashboardValidationMessage.Builder> ... var1);
    }
}

