/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteInsightRulesRequest extends CloudWatchRequest implements
        ToCopyableBuilder<DeleteInsightRulesRequest.Builder, DeleteInsightRulesRequest> {
    private static final SdkField<List<String>> RULE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RuleNames")
            .getter(getter(DeleteInsightRulesRequest::ruleNames))
            .setter(setter(Builder::ruleNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAMES_FIELD));

    private final List<String> ruleNames;

    private DeleteInsightRulesRequest(BuilderImpl builder) {
        super(builder);
        this.ruleNames = builder.ruleNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleNames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRuleNames() {
        return ruleNames != null && !(ruleNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the rule names to delete. If you need to find out the names of your rules, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html"
     * >DescribeInsightRules</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleNames} method.
     * </p>
     * 
     * @return An array of the rule names to delete. If you need to find out the names of your rules, use <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html"
     *         >DescribeInsightRules</a>.
     */
    public final List<String> ruleNames() {
        return ruleNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleNames() ? ruleNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInsightRulesRequest)) {
            return false;
        }
        DeleteInsightRulesRequest other = (DeleteInsightRulesRequest) obj;
        return hasRuleNames() == other.hasRuleNames() && Objects.equals(ruleNames(), other.ruleNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteInsightRulesRequest").add("RuleNames", hasRuleNames() ? ruleNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleNames":
            return Optional.ofNullable(clazz.cast(ruleNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInsightRulesRequest, T> g) {
        return obj -> g.apply((DeleteInsightRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteInsightRulesRequest> {
        /**
         * <p>
         * An array of the rule names to delete. If you need to find out the names of your rules, use <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html"
         * >DescribeInsightRules</a>.
         * </p>
         * 
         * @param ruleNames
         *        An array of the rule names to delete. If you need to find out the names of your rules, use <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html"
         *        >DescribeInsightRules</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNames(Collection<String> ruleNames);

        /**
         * <p>
         * An array of the rule names to delete. If you need to find out the names of your rules, use <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html"
         * >DescribeInsightRules</a>.
         * </p>
         * 
         * @param ruleNames
         *        An array of the rule names to delete. If you need to find out the names of your rules, use <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html"
         *        >DescribeInsightRules</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNames(String... ruleNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private List<String> ruleNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInsightRulesRequest model) {
            super(model);
            ruleNames(model.ruleNames);
        }

        public final Collection<String> getRuleNames() {
            if (ruleNames instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleNames;
        }

        public final void setRuleNames(Collection<String> ruleNames) {
            this.ruleNames = InsightRuleNamesCopier.copy(ruleNames);
        }

        @Override
        public final Builder ruleNames(Collection<String> ruleNames) {
            this.ruleNames = InsightRuleNamesCopier.copy(ruleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleNames(String... ruleNames) {
            ruleNames(Arrays.asList(ruleNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteInsightRulesRequest build() {
            return new DeleteInsightRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
