/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricStreamOutputFormat {
    JSON("json"),
    OPENTELEMETRY0_7("opentelemetry0.7"),
    OPENTELEMETRY1_0("opentelemetry1.0"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricStreamOutputFormat> VALUE_MAP;
    private final String value;

    private MetricStreamOutputFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricStreamOutputFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricStreamOutputFormat> knownValues() {
        EnumSet<MetricStreamOutputFormat> knownValues = EnumSet.allOf(MetricStreamOutputFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricStreamOutputFormat.class, MetricStreamOutputFormat::toString);
    }
}

