/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.metrics.SdkMetric;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.MetricAggregator;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.MetricAggregatorKey;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;

@SdkInternalApi
class SummaryMetricAggregator
implements MetricAggregator {
    private final SdkMetric<?> metric;
    private final List<Dimension> dimensions;
    private final StandardUnit unit;
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;
    private double sum = 0.0;
    private int count = 0;

    SummaryMetricAggregator(MetricAggregatorKey key, StandardUnit unit) {
        this.metric = key.metric();
        this.dimensions = key.dimensions();
        this.unit = unit;
    }

    @Override
    public SdkMetric<?> metric() {
        return this.metric;
    }

    @Override
    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    @Override
    public void addMetricValue(double value) {
        this.min = Double.min(value, this.min);
        this.max = Double.max(value, this.max);
        this.sum += value;
        ++this.count;
    }

    @Override
    public StandardUnit unit() {
        return this.unit;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public double sum() {
        return this.sum;
    }

    public int count() {
        return this.count;
    }
}

