/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.publishers.cloudwatch;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCategory;
import software.amazon.awssdk.metrics.MetricCollection;
import software.amazon.awssdk.metrics.MetricLevel;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.SdkMetric;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.CloudWatchMetricLogger;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.MetricUploader;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.task.AggregateMetricsTask;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.task.UploadMetricsTasks;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.MetricCollectionAggregator;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@ThreadSafe
@Immutable
@SdkPublicApi
public final class CloudWatchMetricPublisher
implements MetricPublisher {
    private static final int MAXIMUM_TASK_QUEUE_SIZE = 128;
    private static final String DEFAULT_NAMESPACE = "AwsSdk/JavaSdk2";
    private static final int DEFAULT_MAXIMUM_CALLS_PER_UPLOAD = 10;
    private static final Duration DEFAULT_UPLOAD_FREQUENCY = Duration.ofMinutes(1L);
    private static final Set<SdkMetric<String>> DEFAULT_DIMENSIONS = Stream.of(CoreMetric.SERVICE_ID, CoreMetric.OPERATION_NAME).collect(Collectors.toSet());
    private static final Set<MetricCategory> DEFAULT_METRIC_CATEGORIES = Collections.singleton(MetricCategory.ALL);
    private static final MetricLevel DEFAULT_METRIC_LEVEL = MetricLevel.INFO;
    private static final Set<SdkMetric<?>> DEFAULT_DETAILED_METRICS = Collections.emptySet();
    private final boolean closeClientWithPublisher;
    private final MetricCollectionAggregator metricAggregator;
    private final MetricUploader metricUploader;
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduledExecutor;
    private final int maximumCallsPerUpload;

    private CloudWatchMetricPublisher(Builder builder) {
        this.closeClientWithPublisher = this.resolveCloseClientWithPublisher(builder);
        this.metricAggregator = new MetricCollectionAggregator(this.resolveNamespace(builder), this.resolveDimensions(builder), this.resolveMetricCategories(builder), this.resolveMetricLevel(builder), this.resolveDetailedMetrics(builder));
        this.metricUploader = new MetricUploader(this.resolveClient(builder));
        this.maximumCallsPerUpload = this.resolveMaximumCallsPerUpload(builder);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().threadNamePrefix("cloud-watch-metric-publisher").build();
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(128), threadFactory);
        long flushFrequencyInMillis = this.resolveUploadFrequency(builder).toMillis();
        this.scheduledExecutor.scheduleAtFixedRate(this::flushMetricsQuietly, flushFrequencyInMillis, flushFrequencyInMillis, TimeUnit.MILLISECONDS);
    }

    private Set<MetricCategory> resolveMetricCategories(Builder builder) {
        return builder.metricCategories == null ? DEFAULT_METRIC_CATEGORIES : new HashSet(builder.metricCategories);
    }

    private MetricLevel resolveMetricLevel(Builder builder) {
        return builder.metricLevel == null ? DEFAULT_METRIC_LEVEL : builder.metricLevel;
    }

    private Set<SdkMetric<?>> resolveDetailedMetrics(Builder builder) {
        return builder.detailedMetrics == null ? DEFAULT_DETAILED_METRICS : new HashSet(builder.detailedMetrics);
    }

    private Set<SdkMetric<String>> resolveDimensions(Builder builder) {
        return builder.dimensions == null ? DEFAULT_DIMENSIONS : new HashSet(builder.dimensions);
    }

    private boolean resolveCloseClientWithPublisher(Builder builder) {
        return builder.client == null;
    }

    private CloudWatchAsyncClient resolveClient(Builder builder) {
        return builder.client == null ? CloudWatchAsyncClient.create() : builder.client;
    }

    private Duration resolveUploadFrequency(Builder builder) {
        return builder.uploadFrequency == null ? DEFAULT_UPLOAD_FREQUENCY : builder.uploadFrequency;
    }

    private String resolveNamespace(Builder builder) {
        return builder.namespace == null ? DEFAULT_NAMESPACE : builder.namespace;
    }

    private int resolveMaximumCallsPerUpload(Builder builder) {
        return builder.maximumCallsPerUpload == null ? 10 : builder.maximumCallsPerUpload;
    }

    public void publish(MetricCollection metricCollection) {
        try {
            this.executor.submit(new AggregateMetricsTask(this.metricAggregator, metricCollection));
        }
        catch (RejectedExecutionException e) {
            CloudWatchMetricLogger.METRIC_LOGGER.warn(() -> "Some AWS SDK client-side metrics have been dropped because an internal executor did not accept them. This usually occurs because your publisher has been shut down or you have generated too many requests for the publisher to handle in a timely fashion.", (Throwable)e);
        }
    }

    private Future<CompletableFuture<?>> flushMetrics() throws InterruptedException {
        while (!this.executor.isShutdown()) {
            try {
                return this.executor.submit(new UploadMetricsTasks(this.metricAggregator, this.metricUploader, this.maximumCallsPerUpload));
            }
            catch (RejectedExecutionException e) {
                Thread.sleep(100L);
            }
        }
        return CompletableFuture.completedFuture(CompletableFuture.completedFuture(null));
    }

    private void flushMetricsQuietly() {
        try {
            this.flushMetrics();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            CloudWatchMetricLogger.METRIC_LOGGER.error(() -> "Interrupted during metric flushing.", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public void close() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runQuietly(Runnable runnable, String taskName) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            CloudWatchMetricLogger.METRIC_LOGGER.warn(() -> "Failed while " + taskName + ".", (Throwable)e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CloudWatchMetricPublisher create() {
        return CloudWatchMetricPublisher.builder().build();
    }

    boolean isShutdown() {
        return this.scheduledExecutor.isShutdown() && this.executor.isShutdown();
    }

    private /* synthetic */ void lambda$close$5() {
        this.metricUploader.close(this.closeClientWithPublisher);
    }

    private static /* synthetic */ String lambda$close$4() {
        return "Timed out during graceful metric publisher shutdown.";
    }

    private static /* synthetic */ String lambda$close$3() {
        return "Failed during graceful metric publisher shutdown.";
    }

    private static /* synthetic */ String lambda$close$2() {
        return "Interrupted during graceful metric publisher shutdown.";
    }

    public static final class Builder {
        private CloudWatchAsyncClient client;
        private Duration uploadFrequency;
        private String namespace;
        private Integer maximumCallsPerUpload;
        private Collection<SdkMetric<String>> dimensions;
        private Collection<MetricCategory> metricCategories;
        private MetricLevel metricLevel;
        private Collection<SdkMetric<?>> detailedMetrics;

        private Builder() {
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder cloudWatchClient(CloudWatchAsyncClient client) {
            this.client = client;
            return this;
        }

        public Builder uploadFrequency(Duration uploadFrequency) {
            this.uploadFrequency = uploadFrequency;
            return this;
        }

        public Builder maximumCallsPerUpload(Integer maximumCallsPerUpload) {
            this.maximumCallsPerUpload = maximumCallsPerUpload;
            return this;
        }

        public Builder dimensions(Collection<SdkMetric<String>> dimensions) {
            this.dimensions = new ArrayList<SdkMetric<String>>(dimensions);
            return this;
        }

        @SafeVarargs
        public final Builder dimensions(SdkMetric<String> ... dimensions) {
            return this.dimensions(Arrays.asList(dimensions));
        }

        public Builder metricCategories(Collection<MetricCategory> metricCategories) {
            this.metricCategories = new ArrayList<MetricCategory>(metricCategories);
            return this;
        }

        public Builder metricCategories(MetricCategory ... metricCategories) {
            return this.metricCategories(Arrays.asList(metricCategories));
        }

        public Builder metricLevel(MetricLevel metricLevel) {
            this.metricLevel = metricLevel;
            return this;
        }

        public Builder detailedMetrics(Collection<SdkMetric<?>> detailedMetrics) {
            this.detailedMetrics = new ArrayList(detailedMetrics);
            return this;
        }

        public Builder detailedMetrics(SdkMetric<?> ... detailedMetrics) {
            return this.detailedMetrics(Arrays.asList(detailedMetrics));
        }

        public CloudWatchMetricPublisher build() {
            return new CloudWatchMetricPublisher(this);
        }
    }
}

