/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.TrailInfo;

public class ListTrailsPublisher
implements SdkPublisher<ListTrailsResponse> {
    private final CloudTrailAsyncClient client;
    private final ListTrailsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrailsPublisher(CloudTrailAsyncClient client, ListTrailsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrailsPublisher(CloudTrailAsyncClient client, ListTrailsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrailsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrailsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrailInfo> trails() {
        return this.flatMapIterable(response -> response.trails());
    }

    private class ListTrailsResponseFetcher
    implements AsyncPageFetcher<ListTrailsResponse> {
        private ListTrailsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrailsResponse> nextPage(ListTrailsResponse previousPage) {
            if (previousPage == null) {
                return ListTrailsPublisher.this.client.listTrails(ListTrailsPublisher.this.firstRequest);
            }
            return ListTrailsPublisher.this.client.listTrails((ListTrailsRequest)((Object)ListTrailsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

