/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.ImportFailureListItem;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse;

public class ListImportFailuresPublisher
implements SdkPublisher<ListImportFailuresResponse> {
    private final CloudTrailAsyncClient client;
    private final ListImportFailuresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImportFailuresPublisher(CloudTrailAsyncClient client, ListImportFailuresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImportFailuresPublisher(CloudTrailAsyncClient client, ListImportFailuresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImportFailuresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImportFailuresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportFailureListItem> failures() {
        return this.flatMapIterable(response -> response.failures());
    }

    private class ListImportFailuresResponseFetcher
    implements AsyncPageFetcher<ListImportFailuresResponse> {
        private ListImportFailuresResponseFetcher() {
        }

        public boolean hasNextPage(ListImportFailuresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImportFailuresResponse> nextPage(ListImportFailuresResponse previousPage) {
            if (previousPage == null) {
                return ListImportFailuresPublisher.this.client.listImportFailures(ListImportFailuresPublisher.this.firstRequest);
            }
            return ListImportFailuresPublisher.this.client.listImportFailures((ListImportFailuresRequest)((Object)ListImportFailuresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

