/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ImportSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ImportSource> {
    private static final SdkField<String> S3_LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3LocationUri").getter(S3ImportSource.getter(S3ImportSource::s3LocationUri)).setter(S3ImportSource.setter(Builder::s3LocationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3LocationUri").build()}).build();
    private static final SdkField<String> S3_BUCKET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketRegion").getter(S3ImportSource.getter(S3ImportSource::s3BucketRegion)).setter(S3ImportSource.setter(Builder::s3BucketRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketRegion").build()}).build();
    private static final SdkField<String> S3_BUCKET_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketAccessRoleArn").getter(S3ImportSource.getter(S3ImportSource::s3BucketAccessRoleArn)).setter(S3ImportSource.setter(Builder::s3BucketAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketAccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_LOCATION_URI_FIELD, S3_BUCKET_REGION_FIELD, S3_BUCKET_ACCESS_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3ImportSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3LocationUri;
    private final String s3BucketRegion;
    private final String s3BucketAccessRoleArn;

    private S3ImportSource(BuilderImpl builder) {
        this.s3LocationUri = builder.s3LocationUri;
        this.s3BucketRegion = builder.s3BucketRegion;
        this.s3BucketAccessRoleArn = builder.s3BucketAccessRoleArn;
    }

    public final String s3LocationUri() {
        return this.s3LocationUri;
    }

    public final String s3BucketRegion() {
        return this.s3BucketRegion;
    }

    public final String s3BucketAccessRoleArn() {
        return this.s3BucketAccessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3LocationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketAccessRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ImportSource)) {
            return false;
        }
        S3ImportSource other = (S3ImportSource)obj;
        return Objects.equals(this.s3LocationUri(), other.s3LocationUri()) && Objects.equals(this.s3BucketRegion(), other.s3BucketRegion()) && Objects.equals(this.s3BucketAccessRoleArn(), other.s3BucketAccessRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"S3ImportSource").add("S3LocationUri", (Object)this.s3LocationUri()).add("S3BucketRegion", (Object)this.s3BucketRegion()).add("S3BucketAccessRoleArn", (Object)this.s3BucketAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3LocationUri": {
                return Optional.ofNullable(clazz.cast(this.s3LocationUri()));
            }
            case "S3BucketRegion": {
                return Optional.ofNullable(clazz.cast(this.s3BucketRegion()));
            }
            case "S3BucketAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.s3BucketAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("S3LocationUri", S3_LOCATION_URI_FIELD);
        map.put("S3BucketRegion", S3_BUCKET_REGION_FIELD);
        map.put("S3BucketAccessRoleArn", S3_BUCKET_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ImportSource, T> g) {
        return obj -> g.apply((S3ImportSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3LocationUri;
        private String s3BucketRegion;
        private String s3BucketAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ImportSource model) {
            this.s3LocationUri(model.s3LocationUri);
            this.s3BucketRegion(model.s3BucketRegion);
            this.s3BucketAccessRoleArn(model.s3BucketAccessRoleArn);
        }

        public final String getS3LocationUri() {
            return this.s3LocationUri;
        }

        public final void setS3LocationUri(String s3LocationUri) {
            this.s3LocationUri = s3LocationUri;
        }

        @Override
        public final Builder s3LocationUri(String s3LocationUri) {
            this.s3LocationUri = s3LocationUri;
            return this;
        }

        public final String getS3BucketRegion() {
            return this.s3BucketRegion;
        }

        public final void setS3BucketRegion(String s3BucketRegion) {
            this.s3BucketRegion = s3BucketRegion;
        }

        @Override
        public final Builder s3BucketRegion(String s3BucketRegion) {
            this.s3BucketRegion = s3BucketRegion;
            return this;
        }

        public final String getS3BucketAccessRoleArn() {
            return this.s3BucketAccessRoleArn;
        }

        public final void setS3BucketAccessRoleArn(String s3BucketAccessRoleArn) {
            this.s3BucketAccessRoleArn = s3BucketAccessRoleArn;
        }

        @Override
        public final Builder s3BucketAccessRoleArn(String s3BucketAccessRoleArn) {
            this.s3BucketAccessRoleArn = s3BucketAccessRoleArn;
            return this;
        }

        public S3ImportSource build() {
            return new S3ImportSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ImportSource> {
        public Builder s3LocationUri(String var1);

        public Builder s3BucketRegion(String var1);

        public Builder s3BucketAccessRoleArn(String var1);
    }
}

