/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryStatistics> {
    private static final SdkField<Integer> RESULTS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResultsCount").getter(QueryStatistics.getter(QueryStatistics::resultsCount)).setter(QueryStatistics.setter(Builder::resultsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsCount").build()}).build();
    private static final SdkField<Integer> TOTAL_RESULTS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalResultsCount").getter(QueryStatistics.getter(QueryStatistics::totalResultsCount)).setter(QueryStatistics.setter(Builder::totalResultsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalResultsCount").build()}).build();
    private static final SdkField<Long> BYTES_SCANNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesScanned").getter(QueryStatistics.getter(QueryStatistics::bytesScanned)).setter(QueryStatistics.setter(Builder::bytesScanned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesScanned").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_COUNT_FIELD, TOTAL_RESULTS_COUNT_FIELD, BYTES_SCANNED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer resultsCount;
    private final Integer totalResultsCount;
    private final Long bytesScanned;

    private QueryStatistics(BuilderImpl builder) {
        this.resultsCount = builder.resultsCount;
        this.totalResultsCount = builder.totalResultsCount;
        this.bytesScanned = builder.bytesScanned;
    }

    public final Integer resultsCount() {
        return this.resultsCount;
    }

    public final Integer totalResultsCount() {
        return this.totalResultsCount;
    }

    public final Long bytesScanned() {
        return this.bytesScanned;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResultsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesScanned());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStatistics)) {
            return false;
        }
        QueryStatistics other = (QueryStatistics)obj;
        return Objects.equals(this.resultsCount(), other.resultsCount()) && Objects.equals(this.totalResultsCount(), other.totalResultsCount()) && Objects.equals(this.bytesScanned(), other.bytesScanned());
    }

    public final String toString() {
        return ToString.builder((String)"QueryStatistics").add("ResultsCount", (Object)this.resultsCount()).add("TotalResultsCount", (Object)this.totalResultsCount()).add("BytesScanned", (Object)this.bytesScanned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultsCount": {
                return Optional.ofNullable(clazz.cast(this.resultsCount()));
            }
            case "TotalResultsCount": {
                return Optional.ofNullable(clazz.cast(this.totalResultsCount()));
            }
            case "BytesScanned": {
                return Optional.ofNullable(clazz.cast(this.bytesScanned()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResultsCount", RESULTS_COUNT_FIELD);
        map.put("TotalResultsCount", TOTAL_RESULTS_COUNT_FIELD);
        map.put("BytesScanned", BYTES_SCANNED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryStatistics, T> g) {
        return obj -> g.apply((QueryStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer resultsCount;
        private Integer totalResultsCount;
        private Long bytesScanned;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStatistics model) {
            this.resultsCount(model.resultsCount);
            this.totalResultsCount(model.totalResultsCount);
            this.bytesScanned(model.bytesScanned);
        }

        public final Integer getResultsCount() {
            return this.resultsCount;
        }

        public final void setResultsCount(Integer resultsCount) {
            this.resultsCount = resultsCount;
        }

        @Override
        public final Builder resultsCount(Integer resultsCount) {
            this.resultsCount = resultsCount;
            return this;
        }

        public final Integer getTotalResultsCount() {
            return this.totalResultsCount;
        }

        public final void setTotalResultsCount(Integer totalResultsCount) {
            this.totalResultsCount = totalResultsCount;
        }

        @Override
        public final Builder totalResultsCount(Integer totalResultsCount) {
            this.totalResultsCount = totalResultsCount;
            return this;
        }

        public final Long getBytesScanned() {
            return this.bytesScanned;
        }

        public final void setBytesScanned(Long bytesScanned) {
            this.bytesScanned = bytesScanned;
        }

        @Override
        public final Builder bytesScanned(Long bytesScanned) {
            this.bytesScanned = bytesScanned;
            return this;
        }

        public QueryStatistics build() {
            return new QueryStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryStatistics> {
        public Builder resultsCount(Integer var1);

        public Builder totalResultsCount(Integer var1);

        public Builder bytesScanned(Long var1);
    }
}

