/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse;

public class ListQueriesPublisher
implements SdkPublisher<ListQueriesResponse> {
    private final CloudTrailAsyncClient client;
    private final ListQueriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQueriesPublisher(CloudTrailAsyncClient client, ListQueriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQueriesPublisher(CloudTrailAsyncClient client, ListQueriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQueriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQueriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListQueriesResponseFetcher
    implements AsyncPageFetcher<ListQueriesResponse> {
        private ListQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListQueriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQueriesResponse> nextPage(ListQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListQueriesPublisher.this.client.listQueries(ListQueriesPublisher.this.firstRequest);
            }
            return ListQueriesPublisher.this.client.listQueries((ListQueriesRequest)((Object)ListQueriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

