/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataResponse;

public class ListInsightsMetricDataIterable
implements SdkIterable<ListInsightsMetricDataResponse> {
    private final CloudTrailClient client;
    private final ListInsightsMetricDataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInsightsMetricDataIterable(CloudTrailClient client, ListInsightsMetricDataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInsightsMetricDataResponseFetcher();
    }

    public Iterator<ListInsightsMetricDataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListInsightsMetricDataResponseFetcher
    implements SyncPageFetcher<ListInsightsMetricDataResponse> {
        private ListInsightsMetricDataResponseFetcher() {
        }

        public boolean hasNextPage(ListInsightsMetricDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInsightsMetricDataResponse nextPage(ListInsightsMetricDataResponse previousPage) {
            if (previousPage == null) {
                return ListInsightsMetricDataIterable.this.client.listInsightsMetricData(ListInsightsMetricDataIterable.this.firstRequest);
            }
            return ListInsightsMetricDataIterable.this.client.listInsightsMetricData((ListInsightsMetricDataRequest)((Object)ListInsightsMetricDataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

