/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReadWriteType {
    READ_ONLY("ReadOnly"),
    WRITE_ONLY("WriteOnly"),
    ALL("All"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReadWriteType> VALUE_MAP;
    private final String value;

    private ReadWriteType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReadWriteType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReadWriteType> knownValues() {
        EnumSet<ReadWriteType> knownValues = EnumSet.allOf(ReadWriteType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReadWriteType.class, ReadWriteType::toString);
    }
}

