/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the objects or data listed below if successful. Otherwise, returns an error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrailsResponse extends CloudTrailResponse implements
        ToCopyableBuilder<DescribeTrailsResponse.Builder, DescribeTrailsResponse> {
    private static final SdkField<List<Trail>> TRAIL_LIST_FIELD = SdkField
            .<List<Trail>> builder(MarshallingType.LIST)
            .memberName("trailList")
            .getter(getter(DescribeTrailsResponse::trailList))
            .setter(setter(Builder::trailList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trailList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trail> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_LIST_FIELD));

    private final List<Trail> trailList;

    private DescribeTrailsResponse(BuilderImpl builder) {
        super(builder);
        this.trailList = builder.trailList;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrailList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTrailList() {
        return trailList != null && !(trailList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of trail objects. Trail objects with string values are only returned if values for the objects exist in
     * a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only returned in
     * results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only appears in
     * results if a trail's log files are encrypted with KMS customer managed keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrailList} method.
     * </p>
     * 
     * @return The list of trail objects. Trail objects with string values are only returned if values for the objects
     *         exist in a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are
     *         only returned in results if a trail is configured to send SNS notifications. Similarly,
     *         <code>KMSKeyId</code> only appears in results if a trail's log files are encrypted with KMS customer
     *         managed keys.
     */
    public final List<Trail> trailList() {
        return trailList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTrailList() ? trailList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrailsResponse)) {
            return false;
        }
        DescribeTrailsResponse other = (DescribeTrailsResponse) obj;
        return hasTrailList() == other.hasTrailList() && Objects.equals(trailList(), other.trailList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrailsResponse").add("TrailList", hasTrailList() ? trailList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trailList":
            return Optional.ofNullable(clazz.cast(trailList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrailsResponse, T> g) {
        return obj -> g.apply((DescribeTrailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTrailsResponse> {
        /**
         * <p>
         * The list of trail objects. Trail objects with string values are only returned if values for the objects exist
         * in a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only
         * returned in results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only
         * appears in results if a trail's log files are encrypted with KMS customer managed keys.
         * </p>
         * 
         * @param trailList
         *        The list of trail objects. Trail objects with string values are only returned if values for the
         *        objects exist in a trail's configuration. For example, <code>SNSTopicName</code> and
         *        <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS
         *        notifications. Similarly, <code>KMSKeyId</code> only appears in results if a trail's log files are
         *        encrypted with KMS customer managed keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailList(Collection<Trail> trailList);

        /**
         * <p>
         * The list of trail objects. Trail objects with string values are only returned if values for the objects exist
         * in a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only
         * returned in results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only
         * appears in results if a trail's log files are encrypted with KMS customer managed keys.
         * </p>
         * 
         * @param trailList
         *        The list of trail objects. Trail objects with string values are only returned if values for the
         *        objects exist in a trail's configuration. For example, <code>SNSTopicName</code> and
         *        <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS
         *        notifications. Similarly, <code>KMSKeyId</code> only appears in results if a trail's log files are
         *        encrypted with KMS customer managed keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailList(Trail... trailList);

        /**
         * <p>
         * The list of trail objects. Trail objects with string values are only returned if values for the objects exist
         * in a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only
         * returned in results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only
         * appears in results if a trail's log files are encrypted with KMS customer managed keys.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.Trail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudtrail.model.Trail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.Trail.Builder#build()} is called immediately and its
         * result is passed to {@link #trailList(List<Trail>)}.
         * 
         * @param trailList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.Trail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trailList(java.util.Collection<Trail>)
         */
        Builder trailList(Consumer<Trail.Builder>... trailList);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private List<Trail> trailList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrailsResponse model) {
            super(model);
            trailList(model.trailList);
        }

        public final List<Trail.Builder> getTrailList() {
            List<Trail.Builder> result = TrailListCopier.copyToBuilder(this.trailList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrailList(Collection<Trail.BuilderImpl> trailList) {
            this.trailList = TrailListCopier.copyFromBuilder(trailList);
        }

        @Override
        public final Builder trailList(Collection<Trail> trailList) {
            this.trailList = TrailListCopier.copy(trailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trailList(Trail... trailList) {
            trailList(Arrays.asList(trailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trailList(Consumer<Trail.Builder>... trailList) {
            trailList(Stream.of(trailList).map(c -> Trail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeTrailsResponse build() {
            return new DescribeTrailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
