/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cloudtrail.internal.CloudTrailServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudtrail.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudtrail.model.AccountHasOngoingImportException;
import software.amazon.awssdk.services.cloudtrail.model.AccountNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.AccountNotRegisteredException;
import software.amazon.awssdk.services.cloudtrail.model.AccountRegisteredException;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.CannotDelegateManagementAccountException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelExistsForEdsException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelMaxLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailAccessNotEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailInvalidClientTokenIdException;
import software.amazon.awssdk.services.cloudtrail.model.CloudWatchLogsDeliveryUnavailableException;
import software.amazon.awssdk.services.cloudtrail.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudtrail.model.ConflictException;
import software.amazon.awssdk.services.cloudtrail.model.CreateChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DelegatedAdminAccountLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.DeleteChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.DisableFederationRequest;
import software.amazon.awssdk.services.cloudtrail.model.DisableFederationResponse;
import software.amazon.awssdk.services.cloudtrail.model.EnableFederationRequest;
import software.amazon.awssdk.services.cloudtrail.model.EnableFederationResponse;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreFederationEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreHasOngoingImportException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreMaxLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreTerminationProtectedException;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusResponse;
import software.amazon.awssdk.services.cloudtrail.model.ImportNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.InactiveEventDataStoreException;
import software.amazon.awssdk.services.cloudtrail.model.InactiveQueryException;
import software.amazon.awssdk.services.cloudtrail.model.InsightNotEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientDependencyServiceAccessPermissionException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientEncryptionPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientS3BucketPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientSnsTopicPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidCloudWatchLogsLogGroupArnException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidCloudWatchLogsRoleArnException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidDateRangeException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventCategoryException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventDataStoreCategoryException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventDataStoreStatusException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventSelectorsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidHomeRegionException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidImportSourceException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidInsightSelectorsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidKmsKeyIdException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidLookupAttributesException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidNextTokenException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidParameterException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidQueryStatementException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidQueryStatusException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidS3BucketNameException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidS3PrefixException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidSnsTopicNameException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidSourceException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTagParameterException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTokenException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTrailNameException;
import software.amazon.awssdk.services.cloudtrail.model.KmsException;
import software.amazon.awssdk.services.cloudtrail.model.KmsKeyNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse;
import software.amazon.awssdk.services.cloudtrail.model.MaxConcurrentQueriesException;
import software.amazon.awssdk.services.cloudtrail.model.MaximumNumberOfTrailsExceededException;
import software.amazon.awssdk.services.cloudtrail.model.NoManagementAccountSlrExistsException;
import software.amazon.awssdk.services.cloudtrail.model.NotOrganizationManagementAccountException;
import software.amazon.awssdk.services.cloudtrail.model.NotOrganizationMasterAccountException;
import software.amazon.awssdk.services.cloudtrail.model.OperationNotPermittedException;
import software.amazon.awssdk.services.cloudtrail.model.OrganizationNotInAllFeaturesModeException;
import software.amazon.awssdk.services.cloudtrail.model.OrganizationsNotInUseException;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.QueryIdNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ResourceArnNotValidException;
import software.amazon.awssdk.services.cloudtrail.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ResourcePolicyNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ResourcePolicyNotValidException;
import software.amazon.awssdk.services.cloudtrail.model.ResourceTypeNotSupportedException;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.S3BucketDoesNotExistException;
import software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.TagsLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.ThrottlingException;
import software.amazon.awssdk.services.cloudtrail.model.TrailAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.TrailNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.TrailNotProvidedException;
import software.amazon.awssdk.services.cloudtrail.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cloudtrail.model.UpdateChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CancelQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeregisterOrganizationDelegatedAdminRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DescribeQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DescribeTrailsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DisableFederationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.EnableFederationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetInsightSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetTrailStatusRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListChannelsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListEventDataStoresRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListImportFailuresRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListInsightsMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListQueriesRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListTrailsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.LookupEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutEventSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutInsightSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RegisterOrganizationDelegatedAdminRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RestoreEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartEventDataStoreIngestionRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartLoggingRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopEventDataStoreIngestionRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopLoggingRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateTrailRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CloudTrailAsyncClient}.
 *
 * @see CloudTrailAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCloudTrailAsyncClient implements CloudTrailAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudTrailAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudTrailAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds one or more tags to a trail, event data store, or channel, up to a limit of 50. Overwrites an existing tag's
     * value when a new value is specified for an existing tag key. Tag key names must be unique; you cannot have two
     * keys with the same name but different values. If you specify a key without a value, the tag will be created with
     * the specified key and a value of null. You can tag a trail or event data store that applies to all Amazon Web
     * Services Regions only from the Region in which the trail or event data store was created (also known as its home
     * Region).
     * </p>
     *
     * @param addTagsRequest
     *        Specifies the tags to add to a trail, event data store, or channel.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>TagsLimitExceededException The number of tags per trail, event data store, or channel has exceeded
     *         the permitted amount. Currently, the limit is 50.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AddTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsRequest, AddTagsResponse>().withOperationName("AddTags")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new AddTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addTagsRequest));
            CompletableFuture<AddTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a query if the query is not in a terminated state, such as <code>CANCELLED</code>, <code>FAILED</code>,
     * <code>TIMED_OUT</code>, or <code>FINISHED</code>. You must specify an ARN value for <code>EventDataStore</code>.
     * The ID of the query that you want to cancel is also required. When you run <code>CancelQuery</code>, the query
     * status might show as <code>CANCELLED</code> even if the operation is not yet finished.
     * </p>
     *
     * @param cancelQueryRequest
     * @return A Java Future containing the result of the CancelQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InactiveQueryException The specified query cannot be canceled because it is in the
     *         <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code> state.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CancelQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CancelQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelQueryResponse> cancelQuery(CancelQueryRequest cancelQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CancelQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelQueryRequest, CancelQueryResponse>()
                            .withOperationName("CancelQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelQueryRequest));
            CompletableFuture<CancelQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a channel for CloudTrail to ingest events from a partner or external source. After you create a channel,
     * a CloudTrail Lake event data store can log events from the partner or source that you specify.
     * </p>
     *
     * @param createChannelRequest
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChannelMaxLimitExceededException This exception is thrown when the maximum number of channels limit
     *         is exceeded.</li>
     *         <li>InvalidSourceException This exception is thrown when the specified value of <code>Source</code> is
     *         not valid.</li>
     *         <li>ChannelAlreadyExistsException This exception is thrown when the provided channel already exists.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>TagsLimitExceededException The number of tags per trail, event data store, or channel has exceeded
     *         the permitted amount. Currently, the limit is 50.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateChannelResponse> createChannel(CreateChannelRequest createChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateChannelRequest, CreateChannelResponse>()
                            .withOperationName("CreateChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createChannelRequest));
            CompletableFuture<CreateChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new event data store.
     * </p>
     *
     * @param createEventDataStoreRequest
     * @return A Java Future containing the result of the CreateEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreAlreadyExistsException An event data store with that name already exists.</li>
     *         <li>EventDataStoreMaxLimitExceededException Your account has used the maximum number of event data
     *         stores.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same Region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEventDataStoreResponse> createEventDataStore(
            CreateEventDataStoreRequest createEventDataStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEventDataStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventDataStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventDataStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEventDataStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEventDataStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEventDataStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEventDataStoreRequest, CreateEventDataStoreResponse>()
                            .withOperationName("CreateEventDataStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEventDataStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEventDataStoreRequest));
            CompletableFuture<CreateEventDataStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
     * </p>
     *
     * @param createTrailRequest
     *        Specifies the settings for each trail.
     * @return A Java Future containing the result of the CreateTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaximumNumberOfTrailsExceededException This exception is thrown when the maximum number of trails is
     *         reached.</li>
     *         <li>TrailAlreadyExistsException This exception is thrown when the specified trail already exists.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientSnsTopicPolicyException This exception is thrown when the policy on the Amazon SNS topic
     *         is not sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidSnsTopicNameException This exception is thrown when the provided SNS topic name is not valid.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>TrailNotProvidedException This exception is no longer in use.</li>
     *         <li>TagsLimitExceededException The number of tags per trail, event data store, or channel has exceeded
     *         the permitted amount. Currently, the limit is 50.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same Region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>InvalidCloudWatchLogsLogGroupArnException This exception is thrown when the provided CloudWatch Logs
     *         log group is not valid.</li>
     *         <li>InvalidCloudWatchLogsRoleArnException This exception is thrown when the provided role is not valid.</li>
     *         <li>CloudWatchLogsDeliveryUnavailableException Cannot set a CloudWatch Logs delivery for this Region.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>CloudTrailInvalidClientTokenIdException This exception is thrown when a call results in the
     *         <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to
     *         send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateTrail" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrailResponse> createTrail(CreateTrailRequest createTrailRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateTrailResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTrailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrailRequest, CreateTrailResponse>()
                            .withOperationName("CreateTrail").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrailRequest));
            CompletableFuture<CreateTrailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a channel.
     * </p>
     *
     * @param deleteChannelRequest
     * @return A Java Future containing the result of the DeleteChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteChannelResponse> deleteChannel(DeleteChannelRequest deleteChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteChannelRequest, DeleteChannelResponse>()
                            .withOperationName("DeleteChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteChannelRequest));
            CompletableFuture<DeleteChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the event data store specified by <code>EventDataStore</code>, which accepts an event data store ARN.
     * After you run <code>DeleteEventDataStore</code>, the event data store enters a <code>PENDING_DELETION</code>
     * state, and is automatically deleted after a wait period of seven days. <code>TerminationProtectionEnabled</code>
     * must be set to <code>False</code> on the event data store and the <code>FederationStatus</code> must be
     * <code>DISABLED</code>. You cannot delete an event data store if <code>TerminationProtectionEnabled</code> is
     * <code>True</code> or the <code>FederationStatus</code> is <code>ENABLED</code>.
     * </p>
     * <p>
     * After you run <code>DeleteEventDataStore</code> on an event data store, you cannot run <code>ListQueries</code>,
     * <code>DescribeQuery</code>, or <code>GetQueryResults</code> on queries that are using an event data store in a
     * <code>PENDING_DELETION</code> state. An event data store in the <code>PENDING_DELETION</code> state does not
     * incur costs.
     * </p>
     *
     * @param deleteEventDataStoreRequest
     * @return A Java Future containing the result of the DeleteEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>EventDataStoreTerminationProtectedException The event data store cannot be deleted because
     *         termination protection is enabled for it.</li>
     *         <li>EventDataStoreHasOngoingImportException This exception is thrown when you try to update or delete an
     *         event data store that currently has an import in progress.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ChannelExistsForEdsException This exception is thrown when the specified event data store cannot yet
     *         be deleted because it is in use by a channel.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>EventDataStoreFederationEnabledException You cannot delete the event data store because Lake query
     *         federation is enabled. To delete the event data store, run the <code>DisableFederation</code> operation
     *         to disable Lake query federation on the event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventDataStoreResponse> deleteEventDataStore(
            DeleteEventDataStoreRequest deleteEventDataStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventDataStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventDataStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventDataStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEventDataStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEventDataStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEventDataStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventDataStoreRequest, DeleteEventDataStoreResponse>()
                            .withOperationName("DeleteEventDataStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEventDataStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEventDataStoreRequest));
            CompletableFuture<DeleteEventDataStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the resource-based policy attached to the CloudTrail channel.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceArnNotValidException This exception is thrown when the provided resource does not exist, or
     *         the ARN format of the resource is not valid. The following is the valid format for a resource ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/MyChannel</code>.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>ResourcePolicyNotFoundException This exception is thrown when the specified resource policy is not
     *         found.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                            .withOperationName("DeleteResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourcePolicyRequest));
            CompletableFuture<DeleteResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a trail. This operation must be called from the Region in which the trail was created.
     * <code>DeleteTrail</code> cannot be called on the shadow trails (replicated trails in other Regions) of a trail
     * that is enabled in all Regions.
     * </p>
     *
     * @param deleteTrailRequest
     *        The request that specifies the name of a trail to delete.
     * @return A Java Future containing the result of the DeleteTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrail" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrailResponse> deleteTrail(DeleteTrailRequest deleteTrailRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTrailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteTrailResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTrailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrailRequest, DeleteTrailResponse>()
                            .withOperationName("DeleteTrail").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTrailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTrailRequest));
            CompletableFuture<DeleteTrailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes CloudTrail delegated administrator permissions from a member account in an organization.
     * </p>
     *
     * @param deregisterOrganizationDelegatedAdminRequest
     *        Removes CloudTrail delegated administrator permissions from a specified member account in an organization
     *        that is currently designated as a delegated administrator.
     * @return A Java Future containing the result of the DeregisterOrganizationDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccountNotFoundException This exception is thrown when the specified account is not found or not part
     *         of an organization.</li>
     *         <li>AccountNotRegisteredException This exception is thrown when the specified account is not registered
     *         as the CloudTrail delegated administrator.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>NotOrganizationManagementAccountException This exception is thrown when the account making the
     *         request is not the organization's management account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeregisterOrganizationDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeregisterOrganizationDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterOrganizationDelegatedAdminResponse> deregisterOrganizationDelegatedAdmin(
            DeregisterOrganizationDelegatedAdminRequest deregisterOrganizationDelegatedAdminRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterOrganizationDelegatedAdminRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deregisterOrganizationDelegatedAdminRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterOrganizationDelegatedAdmin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterOrganizationDelegatedAdminResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeregisterOrganizationDelegatedAdminResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterOrganizationDelegatedAdminResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterOrganizationDelegatedAdminRequest, DeregisterOrganizationDelegatedAdminResponse>()
                            .withOperationName("DeregisterOrganizationDelegatedAdmin").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterOrganizationDelegatedAdminRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterOrganizationDelegatedAdminRequest));
            CompletableFuture<DeregisterOrganizationDelegatedAdminResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched,
     * and query status. If the query results were delivered to an S3 bucket, the response also provides the S3 URI and
     * the delivery status.
     * </p>
     * <p>
     * You must specify either a <code>QueryID</code> or a <code>QueryAlias</code>. Specifying the
     * <code>QueryAlias</code> parameter returns information about the last query run for the alias.
     * </p>
     *
     * @param describeQueryRequest
     * @return A Java Future containing the result of the DescribeQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DescribeQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeQueryResponse> describeQuery(DescribeQueryRequest describeQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeQueryRequest, DescribeQueryResponse>()
                            .withOperationName("DescribeQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeQueryRequest));
            CompletableFuture<DescribeQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves settings for one or more trails associated with the current Region for your account.
     * </p>
     *
     * @param describeTrailsRequest
     *        Returns information about the trail.
     * @return A Java Future containing the result of the DescribeTrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DescribeTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrailsResponse> describeTrails(DescribeTrailsRequest describeTrailsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTrailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTrailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTrailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrailsRequest, DescribeTrailsResponse>()
                            .withOperationName("DescribeTrails").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTrailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTrailsRequest));
            CompletableFuture<DescribeTrailsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables Lake query federation on the specified event data store. When you disable federation, CloudTrail
     * disables the integration with Glue, Lake Formation, and Amazon Athena. After disabling Lake query federation, you
     * can no longer query your event data in Amazon Athena.
     * </p>
     * <p>
     * No CloudTrail Lake data is deleted when you disable federation and you can continue to run queries in CloudTrail
     * Lake.
     * </p>
     *
     * @param disableFederationRequest
     * @return A Java Future containing the result of the DisableFederation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>ConcurrentModificationException You are trying to update a resource when another request is in
     *         progress. Allow sufficient wait time for the previous request to complete, then retry your request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DisableFederation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DisableFederation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableFederationResponse> disableFederation(DisableFederationRequest disableFederationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableFederationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableFederationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableFederation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableFederationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableFederationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableFederationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableFederationRequest, DisableFederationResponse>()
                            .withOperationName("DisableFederation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableFederationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableFederationRequest));
            CompletableFuture<DisableFederationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables Lake query federation on the specified event data store. Federating an event data store lets you view the
     * metadata associated with the event data store in the Glue <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/components-overview.html#data-catalog-intro">Data Catalog</a>
     * and run SQL queries against your event data using Amazon Athena. The table metadata stored in the Glue Data
     * Catalog lets the Athena query engine know how to find, read, and process the data that you want to query.
     * </p>
     * <p>
     * When you enable Lake query federation, CloudTrail creates a managed database named <code>aws:cloudtrail</code>
     * (if the database doesn't already exist) and a managed federated table in the Glue Data Catalog. The event data
     * store ID is used for the table name. CloudTrail registers the role ARN and event data store in <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation-lake-formation.html">Lake
     * Formation</a>, the service responsible for allowing fine-grained access control of the federated resources in the
     * Glue Data Catalog.
     * </p>
     * <p>
     * For more information about Lake query federation, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Federate an event data
     * store</a>.
     * </p>
     *
     * @param enableFederationRequest
     * @return A Java Future containing the result of the EnableFederation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>ConcurrentModificationException You are trying to update a resource when another request is in
     *         progress. Allow sufficient wait time for the previous request to complete, then retry your request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>EventDataStoreFederationEnabledException You cannot delete the event data store because Lake query
     *         federation is enabled. To delete the event data store, run the <code>DisableFederation</code> operation
     *         to disable Lake query federation on the event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.EnableFederation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/EnableFederation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableFederationResponse> enableFederation(EnableFederationRequest enableFederationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableFederationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableFederationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableFederation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableFederationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, EnableFederationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableFederationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableFederationRequest, EnableFederationResponse>()
                            .withOperationName("EnableFederation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableFederationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableFederationRequest));
            CompletableFuture<EnableFederationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific channel.
     * </p>
     *
     * @param getChannelRequest
     * @return A Java Future containing the result of the GetChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetChannelResponse> getChannel(GetChannelRequest getChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetChannelRequest, GetChannelResponse>().withOperationName("GetChannel")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getChannelRequest));
            CompletableFuture<GetChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
     * </p>
     *
     * @param getEventDataStoreRequest
     * @return A Java Future containing the result of the GetEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventDataStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEventDataStoreResponse> getEventDataStore(GetEventDataStoreRequest getEventDataStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventDataStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventDataStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventDataStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEventDataStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEventDataStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEventDataStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEventDataStoreRequest, GetEventDataStoreResponse>()
                            .withOperationName("GetEventDataStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEventDataStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEventDataStoreRequest));
            CompletableFuture<GetEventDataStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the settings for the event selectors that you configured for your trail. The information returned for
     * your event selectors includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If your event selector includes read-only events, write-only events, or all events. This applies to both
     * management events and data events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes management events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes data events, the resources on which you are logging data events.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about logging management and data events, see the following topics in the <i>CloudTrail User
     * Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html"
     * >Logging management events</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">
     * Logging data events</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getEventSelectorsRequest
     * @return A Java Future containing the result of the GetEventSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetEventSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectors" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEventSelectorsResponse> getEventSelectors(GetEventSelectorsRequest getEventSelectorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventSelectorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventSelectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventSelectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEventSelectorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEventSelectorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEventSelectorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEventSelectorsRequest, GetEventSelectorsResponse>()
                            .withOperationName("GetEventSelectors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEventSelectorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEventSelectorsRequest));
            CompletableFuture<GetEventSelectorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific import.
     * </p>
     *
     * @param getImportRequest
     * @return A Java Future containing the result of the GetImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetImport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetImportResponse> getImport(GetImportRequest getImportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetImportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImportRequest, GetImportResponse>().withOperationName("GetImport")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetImportRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getImportRequest));
            CompletableFuture<GetImportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the settings for the Insights event selectors that you configured for your trail or event data store.
     * <code>GetInsightSelectors</code> shows if CloudTrail Insights event logging is enabled on the trail or event data
     * store, and if it is, which Insights types are enabled. If you run <code>GetInsightSelectors</code> on a trail or
     * event data store that does not have Insights events enabled, the operation throws the exception
     * <code>InsightNotEnabledException</code>
     * </p>
     * <p>
     * Specify either the <code>EventDataStore</code> parameter to get Insights event selectors for an event data store,
     * or the <code>TrailName</code> parameter to the get Insights event selectors for a trail. You cannot specify these
     * parameters together.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html"
     * >Logging CloudTrail Insights events</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param getInsightSelectorsRequest
     * @return A Java Future containing the result of the GetInsightSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InsightNotEnabledException If you run <code>GetInsightSelectors</code> on a trail or event data store
     *         that does not have Insights events enabled, the operation throws the exception
     *         <code>InsightNotEnabledException</code>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetInsightSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetInsightSelectors"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInsightSelectorsResponse> getInsightSelectors(
            GetInsightSelectorsRequest getInsightSelectorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInsightSelectorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInsightSelectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInsightSelectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInsightSelectorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInsightSelectorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInsightSelectorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInsightSelectorsRequest, GetInsightSelectorsResponse>()
                            .withOperationName("GetInsightSelectors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetInsightSelectorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getInsightSelectorsRequest));
            CompletableFuture<GetInsightSelectorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets event data results of a query. You must specify the <code>QueryID</code> value returned by the
     * <code>StartQuery</code> operation.
     * </p>
     *
     * @param getQueryResultsRequest
     * @return A Java Future containing the result of the GetQueryResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetQueryResults" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetQueryResultsResponse> getQueryResults(GetQueryResultsRequest getQueryResultsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueryResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueryResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryResults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetQueryResultsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetQueryResultsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetQueryResultsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetQueryResultsRequest, GetQueryResultsResponse>()
                            .withOperationName("GetQueryResults").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetQueryResultsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getQueryResultsRequest));
            CompletableFuture<GetQueryResultsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the JSON text of the resource-based policy document attached to the CloudTrail channel.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceArnNotValidException This exception is thrown when the provided resource does not exist, or
     *         the ARN format of the resource is not valid. The following is the valid format for a resource ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/MyChannel</code>.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>ResourcePolicyNotFoundException This exception is thrown when the specified resource policy is not
     *         found.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourcePolicyRequest, GetResourcePolicyResponse>()
                            .withOperationName("GetResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourcePolicyRequest));
            CompletableFuture<GetResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns settings information for a specified trail.
     * </p>
     *
     * @param getTrailRequest
     * @return A Java Future containing the result of the GetTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrail" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrailResponse> getTrail(GetTrailRequest getTrailRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTrailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetTrailResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTrailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTrailRequest, GetTrailResponse>().withOperationName("GetTrail")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTrailRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getTrailRequest));
            CompletableFuture<GetTrailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery
     * errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns
     * trail status from a single Region. To return trail status from all Regions, you must call the operation on each
     * Region.
     * </p>
     *
     * @param getTrailStatusRequest
     *        The name of a trail about which you want the current status.
     * @return A Java Future containing the result of the GetTrailStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetTrailStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrailStatus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrailStatusResponse> getTrailStatus(GetTrailStatusRequest getTrailStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrailStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrailStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrailStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTrailStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTrailStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTrailStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTrailStatusRequest, GetTrailStatusResponse>()
                            .withOperationName("GetTrailStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTrailStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTrailStatusRequest));
            CompletableFuture<GetTrailStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the channels in the current account, and their source names.
     * </p>
     *
     * @param listChannelsRequest
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListChannelsResponse> listChannels(ListChannelsRequest listChannelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listChannelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListChannels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListChannelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListChannelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListChannelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListChannelsRequest, ListChannelsResponse>()
                            .withOperationName("ListChannels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListChannelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listChannelsRequest));
            CompletableFuture<ListChannelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all event data stores in the account, in the current Region.
     * </p>
     *
     * @param listEventDataStoresRequest
     * @return A Java Future containing the result of the ListEventDataStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListEventDataStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListEventDataStores"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEventDataStoresResponse> listEventDataStores(
            ListEventDataStoresRequest listEventDataStoresRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEventDataStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEventDataStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventDataStores");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEventDataStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEventDataStoresResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEventDataStoresResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEventDataStoresRequest, ListEventDataStoresResponse>()
                            .withOperationName("ListEventDataStores").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEventDataStoresRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEventDataStoresRequest));
            CompletableFuture<ListEventDataStoresResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of failures for the specified import.
     * </p>
     *
     * @param listImportFailuresRequest
     * @return A Java Future containing the result of the ListImportFailures operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImportFailures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImportFailures" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImportFailuresResponse> listImportFailures(ListImportFailuresRequest listImportFailuresRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImportFailuresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportFailuresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImportFailures");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImportFailuresResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImportFailuresResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImportFailuresResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImportFailuresRequest, ListImportFailuresResponse>()
                            .withOperationName("ListImportFailures").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListImportFailuresRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImportFailuresRequest));
            CompletableFuture<ListImportFailuresResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information on all imports, or a select set of imports by <code>ImportStatus</code> or
     * <code>Destination</code>.
     * </p>
     *
     * @param listImportsRequest
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImportsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListImportsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImportsRequest, ListImportsResponse>()
                            .withOperationName("ListImports").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListImportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImportsRequest));
            CompletableFuture<ListImportsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns Insights metrics data for trails that have enabled Insights. The request must include the
     * <code>EventSource</code>, <code>EventName</code>, and <code>InsightType</code> parameters.
     * </p>
     * <p>
     * If the <code>InsightType</code> is set to <code>ApiErrorRateInsight</code>, the request must also include the
     * <code>ErrorCode</code> parameter.
     * </p>
     * <p>
     * The following are the available time periods for <code>ListInsightsMetricData</code>. Each cutoff is inclusive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Data points with a period of 60 seconds (1-minute) are available for 15 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * Data points with a period of 300 seconds (5-minute) are available for 63 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * Data points with a period of 3600 seconds (1 hour) are available for 90 days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Access to the <code>ListInsightsMetricData</code> API operation is linked to the
     * <code>cloudtrail:LookupEvents</code> action. To use this operation, you must have permissions to perform the
     * <code>cloudtrail:LookupEvents</code> action.
     * </p>
     *
     * @param listInsightsMetricDataRequest
     * @return A Java Future containing the result of the ListInsightsMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListInsightsMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListInsightsMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListInsightsMetricDataResponse> listInsightsMetricData(
            ListInsightsMetricDataRequest listInsightsMetricDataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInsightsMetricDataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInsightsMetricDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInsightsMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInsightsMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListInsightsMetricDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInsightsMetricDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInsightsMetricDataRequest, ListInsightsMetricDataResponse>()
                            .withOperationName("ListInsightsMetricData").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListInsightsMetricDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listInsightsMetricDataRequest));
            CompletableFuture<ListInsightsMetricDataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range.
     * The public key is needed to validate digest files that were signed with its corresponding private key.
     * </p>
     * <note>
     * <p>
     * CloudTrail uses different private and public key pairs per Region. Each digest file is signed with a private key
     * unique to its Region. When you validate a digest file from a specific Region, you must look in the same Region
     * for its corresponding public key.
     * </p>
     * </note>
     *
     * @param listPublicKeysRequest
     *        Requests the public keys for a specified time range.
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListPublicKeysResponse> listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPublicKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPublicKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPublicKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPublicKeysResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPublicKeysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPublicKeysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPublicKeysRequest, ListPublicKeysResponse>()
                            .withOperationName("ListPublicKeys").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPublicKeysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPublicKeysRequest));
            CompletableFuture<ListPublicKeysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for
     * <code>EventDataStore</code>. Optionally, to shorten the list of results, you can specify a time range, formatted
     * as timestamps, by adding <code>StartTime</code> and <code>EndTime</code> parameters, and a
     * <code>QueryStatus</code> value. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>,
     * <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
     * <code>CANCELLED</code>.
     * </p>
     *
     * @param listQueriesRequest
     * @return A Java Future containing the result of the ListQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidDateRangeException A date range for the query was specified that is not valid. Be sure that
     *         the start time is chronologically before the end time. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatusException The query status is not valid for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListQueries" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListQueriesResponse> listQueries(ListQueriesRequest listQueriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListQueriesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListQueriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListQueriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListQueriesRequest, ListQueriesResponse>()
                            .withOperationName("ListQueries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListQueriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listQueriesRequest));
            CompletableFuture<ListQueriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags for the specified trails, event data stores, or channels in the current Region.
     * </p>
     *
     * @param listTagsRequest
     *        Specifies a list of tags to return.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>().withOperationName("ListTags")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsRequest));
            CompletableFuture<ListTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists trails that are in the current account.
     * </p>
     *
     * @param listTrailsRequest
     * @return A Java Future containing the result of the ListTrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTrails" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrailsResponse> listTrails(ListTrailsRequest listTrailsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTrailsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTrailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTrailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTrailsRequest, ListTrailsResponse>().withOperationName("ListTrails")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTrailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTrailsRequest));
            CompletableFuture<ListTrailsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Looks up <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events"
     * >management events</a> or <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events"
     * >CloudTrail Insights events</a> that are captured by CloudTrail. You can look up events that occurred in a Region
     * within the last 90 days.
     * </p>
     * <note>
     * <p>
     * <code>LookupEvents</code> returns recent Insights events for trails that enable Insights. To view Insights events
     * for an event data store, you can run queries on your Insights event data store, and you can also view the Lake
     * dashboard for Insights.
     * </p>
     * </note>
     * <p>
     * Lookup supports the following attributes for management events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services access key
     * </p>
     * </li>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * <li>
     * <p>
     * Read only
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource name
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource type
     * </p>
     * </li>
     * <li>
     * <p>
     * User name
     * </p>
     * </li>
     * </ul>
     * <p>
     * Lookup supports the following attributes for Insights events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * </ul>
     * <p>
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The
     * response includes a token that you can use to get the next page of results.
     * </p>
     * <important>
     * <p>
     * The rate of lookup requests is limited to two per second, per account, per Region. If this limit is exceeded, a
     * throttling error occurs.
     * </p>
     * </important>
     *
     * @param lookupEventsRequest
     *        Contains a request for LookupEvents.
     * @return A Java Future containing the result of the LookupEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<LookupEventsResponse> lookupEvents(LookupEventsRequest lookupEventsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(lookupEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, lookupEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "LookupEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<LookupEventsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    LookupEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<LookupEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<LookupEventsRequest, LookupEventsResponse>()
                            .withOperationName("LookupEvents").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new LookupEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(lookupEventsRequest));
            CompletableFuture<LookupEventsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures an event selector or advanced event selectors for your trail. Use event selectors or advanced event
     * selectors to specify management and data event settings for your trail. If you want your trail to log Insights
     * events, be sure the event selector enables logging of the Insights event types you want configured for your
     * trail. For more information about logging Insights events, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html"
     * >Logging Insights events for trails</a> in the <i>CloudTrail User Guide</i>. By default, trails created without
     * specific event selectors are configured to log all read and write management events, and no data events.
     * </p>
     * <p>
     * When an event occurs in your account, CloudTrail evaluates the event selectors or advanced event selectors in all
     * trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the
     * event doesn't match any event selector, the trail doesn't log the event.
     * </p>
     * <p>
     * Example
     * </p>
     * <ol>
     * <li>
     * <p>
     * You create an event selector for a trail and specify that you want write-only events.
     * </p>
     * </li>
     * <li>
     * <p>
     * The EC2 <code>GetConsoleOutput</code> and <code>RunInstances</code> API operations occur in your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * CloudTrail evaluates whether the events match your event selectors.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>RunInstances</code> is a write-only event and it matches your event selector. The trail logs the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>GetConsoleOutput</code> is a read-only event that doesn't match your event selector. The trail doesn't
     * log the event.
     * </p>
     * </li>
     * </ol>
     * <p>
     * The <code>PutEventSelectors</code> operation must be called from the Region in which the trail was created;
     * otherwise, an <code>InvalidHomeRegionException</code> exception is thrown.
     * </p>
     * <p>
     * You can configure up to five event selectors for each trail. For more information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html"
     * >Logging management events</a>, <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html"
     * >Logging data events</a>, and <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Quotas in
     * CloudTrail</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500
     * values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or
     * <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any
     * existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a
     * href
     * ="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging
     * data events</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param putEventSelectorsRequest
     * @return A Java Future containing the result of the PutEventSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutEventSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectors" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutEventSelectorsResponse> putEventSelectors(PutEventSelectorsRequest putEventSelectorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEventSelectorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEventSelectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEventSelectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEventSelectorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutEventSelectorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEventSelectorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEventSelectorsRequest, PutEventSelectorsResponse>()
                            .withOperationName("PutEventSelectors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutEventSelectorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putEventSelectorsRequest));
            CompletableFuture<PutEventSelectorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an
     * existing trail or event data store. You also use <code>PutInsightSelectors</code> to turn off Insights event
     * logging, by passing an empty list of Insights types. The valid Insights event types are
     * <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code>.
     * </p>
     * <p>
     * To enable Insights on an event data store, you must specify the ARNs (or ID suffix of the ARNs) for the source
     * event data store (<code>EventDataStore</code>) and the destination event data store (
     * <code>InsightsDestination</code>). The source event data store logs management events and enables Insights. The
     * destination event data store logs Insights events based upon the management event activity of the source event
     * data store. The source and destination event data stores must belong to the same Amazon Web Services account.
     * </p>
     * <p>
     * To log Insights events for a trail, you must specify the name (<code>TrailName</code>) of the CloudTrail trail
     * for which you want to change or add Insights selectors.
     * </p>
     * <p>
     * To log CloudTrail Insights events on API call volume, the trail or event data store must log <code>write</code>
     * management events. To log CloudTrail Insights events on API error rate, the trail or event data store must log
     * <code>read</code> or <code>write</code> management events. You can call <code>GetEventSelectors</code> on a trail
     * to check whether the trail logs management events. You can call <code>GetEventDataStore</code> on an event data
     * store to check whether the event data store logs management events.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html"
     * >Logging CloudTrail Insights events</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param putInsightSelectorsRequest
     * @return A Java Future containing the result of the PutInsightSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>InvalidInsightSelectorsException For <code>PutInsightSelectors</code>, this exception is thrown when
     *         the formatting or syntax of the <code>InsightSelectors</code> JSON statement is not valid, or the
     *         specified <code>InsightType</code> in the <code>InsightSelectors</code> statement is not valid. Valid
     *         values for <code>InsightType</code> are <code>ApiCallRateInsight</code> and
     *         <code>ApiErrorRateInsight</code>. To enable Insights on an event data store, the destination event data
     *         store specified by the <code>InsightsDestination</code> parameter must log Insights events and the source
     *         event data store specified by the <code>EventDataStore</code> parameter must log management events.</p>
     *         <p>
     *         For <code>UpdateEventDataStore</code>, this exception is thrown if Insights are enabled on the event data
     *         store and the updated advanced event selectors are not compatible with the configured
     *         <code>InsightSelectors</code>. If the <code>InsightSelectors</code> includes an <code>InsightType</code>
     *         of <code>ApiCallRateInsight</code>, the source event data store must log <code>write</code> management
     *         events. If the <code>InsightSelectors</code> includes an <code>InsightType</code> of
     *         <code>ApiErrorRateInsight</code>, the source event data store must log management events.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutInsightSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutInsightSelectors"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutInsightSelectorsResponse> putInsightSelectors(
            PutInsightSelectorsRequest putInsightSelectorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putInsightSelectorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putInsightSelectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutInsightSelectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutInsightSelectorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutInsightSelectorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutInsightSelectorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutInsightSelectorsRequest, PutInsightSelectorsResponse>()
                            .withOperationName("PutInsightSelectors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutInsightSelectorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putInsightSelectorsRequest));
            CompletableFuture<PutInsightSelectorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a resource-based permission policy to a CloudTrail channel that is used for an integration with an event
     * source outside of Amazon Web Services. For more information about resource-based policies, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html"
     * >CloudTrail resource-based policy examples</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceArnNotValidException This exception is thrown when the provided resource does not exist, or
     *         the ARN format of the resource is not valid. The following is the valid format for a resource ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/MyChannel</code>.</li>
     *         <li>ResourcePolicyNotValidException This exception is thrown when the resouce-based policy has syntax
     *         errors, or contains a principal that is not valid. </p>
     *         <p>
     *         The following are requirements for the resource policy:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contains only one action: cloudtrail-data:PutAuditEvents
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Contains at least one statement. The policy can have a maximum of 20 statements.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each statement contains at least one principal. A statement can have a maximum of 50 principals.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutResourcePolicyRequest, PutResourcePolicyResponse>()
                            .withOperationName("PutResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putResourcePolicyRequest));
            CompletableFuture<PutResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers an organization’s member account as the CloudTrail <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-delegated-administrator.html"
     * >delegated administrator</a>.
     * </p>
     *
     * @param registerOrganizationDelegatedAdminRequest
     *        Specifies an organization member account ID as a CloudTrail delegated administrator.
     * @return A Java Future containing the result of the RegisterOrganizationDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccountRegisteredException This exception is thrown when the account is already registered as the
     *         CloudTrail delegated administrator.</li>
     *         <li>AccountNotFoundException This exception is thrown when the specified account is not found or not part
     *         of an organization.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>CannotDelegateManagementAccountException This exception is thrown when the management account of an
     *         organization is registered as the CloudTrail delegated administrator.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>DelegatedAdminAccountLimitExceededException This exception is thrown when the maximum number of
     *         CloudTrail delegated administrators is reached.</li>
     *         <li>NotOrganizationManagementAccountException This exception is thrown when the account making the
     *         request is not the organization's management account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RegisterOrganizationDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RegisterOrganizationDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterOrganizationDelegatedAdminResponse> registerOrganizationDelegatedAdmin(
            RegisterOrganizationDelegatedAdminRequest registerOrganizationDelegatedAdminRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerOrganizationDelegatedAdminRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                registerOrganizationDelegatedAdminRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterOrganizationDelegatedAdmin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterOrganizationDelegatedAdminResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, RegisterOrganizationDelegatedAdminResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterOrganizationDelegatedAdminResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterOrganizationDelegatedAdminRequest, RegisterOrganizationDelegatedAdminResponse>()
                            .withOperationName("RegisterOrganizationDelegatedAdmin").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RegisterOrganizationDelegatedAdminRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(registerOrganizationDelegatedAdminRequest));
            CompletableFuture<RegisterOrganizationDelegatedAdminResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from a trail, event data store, or channel.
     * </p>
     *
     * @param removeTagsRequest
     *        Specifies the tags to remove from a trail, event data store, or channel.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RemoveTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RemoveTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsRequest, RemoveTagsResponse>().withOperationName("RemoveTags")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeTagsRequest));
            CompletableFuture<RemoveTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restores a deleted event data store specified by <code>EventDataStore</code>, which accepts an event data store
     * ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring
     * an event data store can take several minutes, depending on the size of the event data store.
     * </p>
     *
     * @param restoreEventDataStoreRequest
     * @return A Java Future containing the result of the RestoreEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>EventDataStoreMaxLimitExceededException Your account has used the maximum number of event data
     *         stores.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RestoreEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RestoreEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreEventDataStoreResponse> restoreEventDataStore(
            RestoreEventDataStoreRequest restoreEventDataStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreEventDataStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreEventDataStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreEventDataStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RestoreEventDataStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RestoreEventDataStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RestoreEventDataStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreEventDataStoreRequest, RestoreEventDataStoreResponse>()
                            .withOperationName("RestoreEventDataStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RestoreEventDataStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(restoreEventDataStoreRequest));
            CompletableFuture<RestoreEventDataStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts the ingestion of live events on an event data store specified as either an ARN or the ID portion of the
     * ARN. To start ingestion, the event data store <code>Status</code> must be <code>STOPPED_INGESTION</code> and the
     * <code>eventCategory</code> must be <code>Management</code>, <code>Data</code>, or <code>ConfigurationItem</code>.
     * </p>
     *
     * @param startEventDataStoreIngestionRequest
     * @return A Java Future containing the result of the StartEventDataStoreIngestion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartEventDataStoreIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartEventDataStoreIngestion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartEventDataStoreIngestionResponse> startEventDataStoreIngestion(
            StartEventDataStoreIngestionRequest startEventDataStoreIngestionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startEventDataStoreIngestionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startEventDataStoreIngestionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartEventDataStoreIngestion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartEventDataStoreIngestionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartEventDataStoreIngestionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartEventDataStoreIngestionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartEventDataStoreIngestionRequest, StartEventDataStoreIngestionResponse>()
                            .withOperationName("StartEventDataStoreIngestion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartEventDataStoreIngestionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startEventDataStoreIngestionRequest));
            CompletableFuture<StartEventDataStoreIngestionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an import of logged trail events from a source S3 bucket to a destination event data store. By default,
     * CloudTrail only imports events contained in the S3 bucket's <code>CloudTrail</code> prefix and the prefixes
     * inside the <code>CloudTrail</code> prefix, and does not check prefixes for other Amazon Web Services services. If
     * you want to import CloudTrail events contained in another prefix, you must include the prefix in the
     * <code>S3LocationUri</code>. For more considerations about importing trail events, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-copy-trail-to-lake.html#cloudtrail-trail-copy-considerations"
     * >Considerations</a>.
     * </p>
     * <p>
     * When you start a new import, the <code>Destinations</code> and <code>ImportSource</code> parameters are required.
     * Before starting a new import, disable any access control lists (ACLs) attached to the source S3 bucket. For more
     * information about disabling ACLs, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of
     * objects and disabling ACLs for your bucket</a>.
     * </p>
     * <p>
     * When you retry an import, the <code>ImportID</code> parameter is required.
     * </p>
     * <note>
     * <p>
     * If the destination event data store is for an organization, you must use the management account to import trail
     * events. You cannot use the delegated administrator account for the organization.
     * </p>
     * </note>
     *
     * @param startImportRequest
     * @return A Java Future containing the result of the StartImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccountHasOngoingImportException This exception is thrown when you start a new import and a previous
     *         import is still in progress.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidImportSourceException This exception is thrown when the provided source S3 bucket is not valid
     *         for import.</li>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartImportResponse> startImport(StartImportRequest startImportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartImportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartImportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartImportRequest, StartImportResponse>()
                            .withOperationName("StartImport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartImportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startImportRequest));
            CompletableFuture<StartImportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is
     * enabled in all Regions, this operation must be called from the Region in which the trail was created. This
     * operation cannot be called on the shadow trails (replicated trails in other Regions) of a trail that is enabled
     * in all Regions.
     * </p>
     *
     * @param startLoggingRequest
     *        The request to CloudTrail to start logging Amazon Web Services API calls for an account.
     * @return A Java Future containing the result of the StartLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartLogging" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartLoggingResponse> startLogging(StartLoggingRequest startLoggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startLoggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startLoggingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartLogging");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartLoggingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartLoggingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartLoggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartLoggingRequest, StartLoggingResponse>()
                            .withOperationName("StartLogging").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartLoggingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startLoggingRequest));
            CompletableFuture<StartLoggingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a CloudTrail Lake query. Use the <code>QueryStatement</code> parameter to provide your SQL query, enclosed
     * in single quotation marks. Use the optional <code>DeliveryS3Uri</code> parameter to deliver the query results to
     * an S3 bucket.
     * </p>
     * <p>
     * <code>StartQuery</code> requires you specify either the <code>QueryStatement</code> parameter, or a
     * <code>QueryAlias</code> and any <code>QueryParameters</code>. In the current release, the <code>QueryAlias</code>
     * and <code>QueryParameters</code> parameters are used only for the queries that populate the CloudTrail Lake
     * dashboards.
     * </p>
     *
     * @param startQueryRequest
     * @return A Java Future containing the result of the StartQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatementException The query that was submitted has validation errors, or uses incorrect
     *         syntax or unsupported keywords. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>MaxConcurrentQueriesException You are already running the maximum number of concurrent queries. The
     *         maximum number of concurrent queries is 10. Wait a minute for some queries to finish, and then run the
     *         query again.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartQueryResponse> startQuery(StartQueryRequest startQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartQueryRequest, StartQueryResponse>().withOperationName("StartQuery")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startQueryRequest));
            CompletableFuture<StartQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops the ingestion of live events on an event data store specified as either an ARN or the ID portion of the
     * ARN. To stop ingestion, the event data store <code>Status</code> must be <code>ENABLED</code> and the
     * <code>eventCategory</code> must be <code>Management</code>, <code>Data</code>, or <code>ConfigurationItem</code>.
     * </p>
     *
     * @param stopEventDataStoreIngestionRequest
     * @return A Java Future containing the result of the StopEventDataStoreIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopEventDataStoreIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopEventDataStoreIngestion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopEventDataStoreIngestionResponse> stopEventDataStoreIngestion(
            StopEventDataStoreIngestionRequest stopEventDataStoreIngestionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopEventDataStoreIngestionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopEventDataStoreIngestionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopEventDataStoreIngestion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopEventDataStoreIngestionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopEventDataStoreIngestionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopEventDataStoreIngestionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopEventDataStoreIngestionRequest, StopEventDataStoreIngestionResponse>()
                            .withOperationName("StopEventDataStoreIngestion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopEventDataStoreIngestionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopEventDataStoreIngestionRequest));
            CompletableFuture<StopEventDataStoreIngestionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a specified import.
     * </p>
     *
     * @param stopImportRequest
     * @return A Java Future containing the result of the StopImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopImport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopImportResponse> stopImport(StopImportRequest stopImportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopImport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StopImportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopImportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopImportRequest, StopImportResponse>().withOperationName("StopImport")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopImportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopImportRequest));
            CompletableFuture<StopImportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most
     * circumstances, there is no need to use this action. You can update a trail without stopping it first. This action
     * is the only way to stop recording. For a trail enabled in all Regions, this operation must be called from the
     * Region in which the trail was created, or an <code>InvalidHomeRegionException</code> will occur. This operation
     * cannot be called on the shadow trails (replicated trails in other Regions) of a trail enabled in all Regions.
     * </p>
     *
     * @param stopLoggingRequest
     *        Passes the request to CloudTrail to stop logging Amazon Web Services API calls for the specified account.
     * @return A Java Future containing the result of the StopLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopLogging" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopLoggingResponse> stopLogging(StopLoggingRequest stopLoggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopLoggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopLoggingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopLogging");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopLoggingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StopLoggingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopLoggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopLoggingRequest, StopLoggingResponse>()
                            .withOperationName("StopLogging").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopLoggingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopLoggingRequest));
            CompletableFuture<StopLoggingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a channel specified by a required channel ARN or UUID.
     * </p>
     *
     * @param updateChannelRequest
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ChannelNotFoundException This exception is thrown when CloudTrail cannot find the specified channel.</li>
     *         <li>ChannelAlreadyExistsException This exception is thrown when the provided channel already exists.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateChannelResponse> updateChannel(UpdateChannelRequest updateChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateChannelRequest, UpdateChannelResponse>()
                            .withOperationName("UpdateChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateChannelRequest));
            CompletableFuture<UpdateChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an event data store. The required <code>EventDataStore</code> value is an ARN or the ID portion of the
     * ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws
     * an error. <code>RetentionPeriod</code> is in days, and valid values are integers between 7 and 3653 if the
     * <code>BillingMode</code> is set to <code>EXTENDABLE_RETENTION_PRICING</code>, or between 7 and 2557 if
     * <code>BillingMode</code> is set to <code>FIXED_RETENTION_PRICING</code>. By default,
     * <code>TerminationProtection</code> is enabled.
     * </p>
     * <p>
     * For event data stores for CloudTrail events, <code>AdvancedEventSelectors</code> includes or excludes management
     * or data events in your event data store. For more information about <code>AdvancedEventSelectors</code>, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html">
     * AdvancedEventSelectors</a>.
     * </p>
     * <p>
     * For event data stores for CloudTrail Insights events, Config configuration items, Audit Manager evidence, or
     * non-Amazon Web Services events, <code>AdvancedEventSelectors</code> includes events of that type in your event
     * data store.
     * </p>
     *
     * @param updateEventDataStoreRequest
     * @return A Java Future containing the result of the UpdateEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreAlreadyExistsException An event data store with that name already exists.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>InvalidInsightSelectorsException For <code>PutInsightSelectors</code>, this exception is thrown when
     *         the formatting or syntax of the <code>InsightSelectors</code> JSON statement is not valid, or the
     *         specified <code>InsightType</code> in the <code>InsightSelectors</code> statement is not valid. Valid
     *         values for <code>InsightType</code> are <code>ApiCallRateInsight</code> and
     *         <code>ApiErrorRateInsight</code>. To enable Insights on an event data store, the destination event data
     *         store specified by the <code>InsightsDestination</code> parameter must log Insights events and the source
     *         event data store specified by the <code>EventDataStore</code> parameter must log management events.</p>
     *         <p>
     *         For <code>UpdateEventDataStore</code>, this exception is thrown if Insights are enabled on the event data
     *         store and the updated advanced event selectors are not compatible with the configured
     *         <code>InsightSelectors</code>. If the <code>InsightSelectors</code> includes an <code>InsightType</code>
     *         of <code>ApiCallRateInsight</code>, the source event data store must log <code>write</code> management
     *         events. If the <code>InsightSelectors</code> includes an <code>InsightType</code> of
     *         <code>ApiErrorRateInsight</code>, the source event data store must log management events.</li>
     *         <li>EventDataStoreHasOngoingImportException This exception is thrown when you try to update or delete an
     *         event data store that currently has an import in progress.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same Region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEventDataStoreResponse> updateEventDataStore(
            UpdateEventDataStoreRequest updateEventDataStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEventDataStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEventDataStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventDataStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEventDataStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEventDataStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEventDataStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEventDataStoreRequest, UpdateEventDataStoreResponse>()
                            .withOperationName("UpdateEventDataStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEventDataStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEventDataStoreRequest));
            CompletableFuture<UpdateEventDataStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail
     * do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery.
     * If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the
     * bucket. <code>UpdateTrail</code> must be called from the Region in which the trail was created; otherwise, an
     * <code>InvalidHomeRegionException</code> is thrown.
     * </p>
     *
     * @param updateTrailRequest
     *        Specifies settings to update for the trail.
     * @return A Java Future containing the result of the UpdateTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientSnsTopicPolicyException This exception is thrown when the policy on the Amazon SNS topic
     *         is not sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidSnsTopicNameException This exception is thrown when the provided SNS topic name is not valid.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>TrailNotProvidedException This exception is no longer in use.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with an ARN that
     *         is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code></li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource, or because another operation is modifying the resource. If this exception occurs, wait a
     *         few minutes, and then try the operation again.</li>
     *         <li>ThrottlingException This exception is thrown when the request rate exceeds the limit.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         Region other than the Region in which the trail was created.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same Region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same Region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>InvalidCloudWatchLogsLogGroupArnException This exception is thrown when the provided CloudWatch Logs
     *         log group is not valid.</li>
     *         <li>InvalidCloudWatchLogsRoleArnException This exception is thrown when the provided role is not valid.</li>
     *         <li>CloudWatchLogsDeliveryUnavailableException Cannot set a CloudWatch Logs delivery for this Region.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM identity
     *         that is used to create the organization resource lacks one or more required permissions for creating an
     *         organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>CloudTrailInvalidClientTokenIdException This exception is thrown when a call results in the
     *         <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to
     *         send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateTrail" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTrailResponse> updateTrail(UpdateTrailRequest updateTrailRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTrailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTrail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTrailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateTrailResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateTrailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTrailRequest, UpdateTrailResponse>()
                            .withOperationName("UpdateTrail").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateTrailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateTrailRequest));
            CompletableFuture<UpdateTrailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final CloudTrailServiceClientConfiguration serviceClientConfiguration() {
        return new CloudTrailServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CloudTrailException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                                .exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                                .exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException")
                                .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException")
                                .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceARNNotValidException")
                                .exceptionBuilderSupplier(ResourceArnNotValidException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                                .exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSourceException")
                                .exceptionBuilderSupplier(InvalidSourceException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                                .exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException")
                                .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                                .exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException")
                                .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                                .exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException")
                                .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException")
                                .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException")
                                .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperationException")
                                .exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                                .exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccountNotRegisteredException")
                                .exceptionBuilderSupplier(AccountNotRegisteredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                                .exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                                .exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                                .exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTrailNameException")
                                .exceptionBuilderSupplier(InvalidTrailNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidImportSourceException")
                                .exceptionBuilderSupplier(InvalidImportSourceException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                                .exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException")
                                .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                                .exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException")
                                .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidS3PrefixException")
                                .exceptionBuilderSupplier(InvalidS3PrefixException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                                .exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidHomeRegionException")
                                .exceptionBuilderSupplier(InvalidHomeRegionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException")
                                .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException")
                                .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ChannelARNInvalidException")
                                .exceptionBuilderSupplier(ChannelArnInvalidException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryIdNotFoundException")
                                .exceptionBuilderSupplier(QueryIdNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException")
                                .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrailNotProvidedException")
                                .exceptionBuilderSupplier(TrailNotProvidedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidQueryStatusException")
                                .exceptionBuilderSupplier(InvalidQueryStatusException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEventCategoryException")
                                .exceptionBuilderSupplier(InvalidEventCategoryException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KmsException").exceptionBuilderSupplier(KmsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException")
                                .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                                .exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagsLimitExceededException")
                                .exceptionBuilderSupplier(TagsLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException")
                                .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException")
                                .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccountRegisteredException")
                                .exceptionBuilderSupplier(AccountRegisteredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationNotPermittedException")
                                .exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException")
                                .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException")
                                .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTokenException")
                                .exceptionBuilderSupplier(InvalidTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                                .exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidQueryStatementException")
                                .exceptionBuilderSupplier(InvalidQueryStatementException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTimeRangeException")
                                .exceptionBuilderSupplier(InvalidTimeRangeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ImportNotFoundException")
                                .exceptionBuilderSupplier(ImportNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccountNotFoundException")
                                .exceptionBuilderSupplier(AccountNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                                .exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMaxResultsException")
                                .exceptionBuilderSupplier(InvalidMaxResultsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException")
                                .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                                .exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InactiveQueryException")
                                .exceptionBuilderSupplier(InactiveQueryException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException")
                                .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException")
                                .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagParameterException")
                                .exceptionBuilderSupplier(InvalidTagParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrailNotFoundException")
                                .exceptionBuilderSupplier(TrailNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                                .exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                                .exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException")
                                .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDateRangeException")
                                .exceptionBuilderSupplier(InvalidDateRangeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ChannelNotFoundException")
                                .exceptionBuilderSupplier(ChannelNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException")
                                .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                                .exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException")
                                .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsightNotEnabledException")
                                .exceptionBuilderSupplier(InsightNotEnabledException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CloudTrailServiceClientConfigurationBuilder serviceConfigBuilder = new CloudTrailServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
