/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.AdvancedFieldSelector;
import software.amazon.awssdk.services.cloudtrail.model.AdvancedFieldSelectorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdvancedEventSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdvancedEventSelector> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AdvancedEventSelector.getter(AdvancedEventSelector::name)).setter(AdvancedEventSelector.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<AdvancedFieldSelector>> FIELD_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldSelectors").getter(AdvancedEventSelector.getter(AdvancedEventSelector::fieldSelectors)).setter(AdvancedEventSelector.setter(Builder::fieldSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdvancedFieldSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FIELD_SELECTORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<AdvancedFieldSelector> fieldSelectors;

    private AdvancedEventSelector(BuilderImpl builder) {
        this.name = builder.name;
        this.fieldSelectors = builder.fieldSelectors;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasFieldSelectors() {
        return this.fieldSelectors != null && !(this.fieldSelectors instanceof SdkAutoConstructList);
    }

    public final List<AdvancedFieldSelector> fieldSelectors() {
        return this.fieldSelectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldSelectors() ? this.fieldSelectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedEventSelector)) {
            return false;
        }
        AdvancedEventSelector other = (AdvancedEventSelector)obj;
        return Objects.equals(this.name(), other.name()) && this.hasFieldSelectors() == other.hasFieldSelectors() && Objects.equals(this.fieldSelectors(), other.fieldSelectors());
    }

    public final String toString() {
        return ToString.builder((String)"AdvancedEventSelector").add("Name", (Object)this.name()).add("FieldSelectors", this.hasFieldSelectors() ? this.fieldSelectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "FieldSelectors": {
                return Optional.ofNullable(clazz.cast(this.fieldSelectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdvancedEventSelector, T> g) {
        return obj -> g.apply((AdvancedEventSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<AdvancedFieldSelector> fieldSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedEventSelector model) {
            this.name(model.name);
            this.fieldSelectors(model.fieldSelectors);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AdvancedFieldSelector.Builder> getFieldSelectors() {
            List<AdvancedFieldSelector.Builder> result = AdvancedFieldSelectorsCopier.copyToBuilder(this.fieldSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldSelectors(Collection<AdvancedFieldSelector.BuilderImpl> fieldSelectors) {
            this.fieldSelectors = AdvancedFieldSelectorsCopier.copyFromBuilder(fieldSelectors);
        }

        @Override
        public final Builder fieldSelectors(Collection<AdvancedFieldSelector> fieldSelectors) {
            this.fieldSelectors = AdvancedFieldSelectorsCopier.copy(fieldSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldSelectors(AdvancedFieldSelector ... fieldSelectors) {
            this.fieldSelectors(Arrays.asList(fieldSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldSelectors(Consumer<AdvancedFieldSelector.Builder> ... fieldSelectors) {
            this.fieldSelectors(Stream.of(fieldSelectors).map(c -> (AdvancedFieldSelector)((AdvancedFieldSelector.Builder)AdvancedFieldSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AdvancedEventSelector build() {
            return new AdvancedEventSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdvancedEventSelector> {
        public Builder name(String var1);

        public Builder fieldSelectors(Collection<AdvancedFieldSelector> var1);

        public Builder fieldSelectors(AdvancedFieldSelector ... var1);

        public Builder fieldSelectors(Consumer<AdvancedFieldSelector.Builder> ... var1);
    }
}

