/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LiteralArrayOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LiteralArrayOptions> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(LiteralArrayOptions.getter(LiteralArrayOptions::defaultValue)).setter(LiteralArrayOptions.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<String> SOURCE_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFields").getter(LiteralArrayOptions.getter(LiteralArrayOptions::sourceFields)).setter(LiteralArrayOptions.setter(Builder::sourceFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFields").build()}).build();
    private static final SdkField<Boolean> FACET_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FacetEnabled").getter(LiteralArrayOptions.getter(LiteralArrayOptions::facetEnabled)).setter(LiteralArrayOptions.setter(Builder::facetEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetEnabled").build()}).build();
    private static final SdkField<Boolean> SEARCH_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SearchEnabled").getter(LiteralArrayOptions.getter(LiteralArrayOptions::searchEnabled)).setter(LiteralArrayOptions.setter(Builder::searchEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchEnabled").build()}).build();
    private static final SdkField<Boolean> RETURN_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReturnEnabled").getter(LiteralArrayOptions.getter(LiteralArrayOptions::returnEnabled)).setter(LiteralArrayOptions.setter(Builder::returnEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, SOURCE_FIELDS_FIELD, FACET_ENABLED_FIELD, SEARCH_ENABLED_FIELD, RETURN_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LiteralArrayOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String defaultValue;
    private final String sourceFields;
    private final Boolean facetEnabled;
    private final Boolean searchEnabled;
    private final Boolean returnEnabled;

    private LiteralArrayOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceFields = builder.sourceFields;
        this.facetEnabled = builder.facetEnabled;
        this.searchEnabled = builder.searchEnabled;
        this.returnEnabled = builder.returnEnabled;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final String sourceFields() {
        return this.sourceFields;
    }

    public final Boolean facetEnabled() {
        return this.facetEnabled;
    }

    public final Boolean searchEnabled() {
        return this.searchEnabled;
    }

    public final Boolean returnEnabled() {
        return this.returnEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.facetEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiteralArrayOptions)) {
            return false;
        }
        LiteralArrayOptions other = (LiteralArrayOptions)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.sourceFields(), other.sourceFields()) && Objects.equals(this.facetEnabled(), other.facetEnabled()) && Objects.equals(this.searchEnabled(), other.searchEnabled()) && Objects.equals(this.returnEnabled(), other.returnEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"LiteralArrayOptions").add("DefaultValue", (Object)this.defaultValue()).add("SourceFields", (Object)this.sourceFields()).add("FacetEnabled", (Object)this.facetEnabled()).add("SearchEnabled", (Object)this.searchEnabled()).add("ReturnEnabled", (Object)this.returnEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "SourceFields": {
                return Optional.ofNullable(clazz.cast(this.sourceFields()));
            }
            case "FacetEnabled": {
                return Optional.ofNullable(clazz.cast(this.facetEnabled()));
            }
            case "SearchEnabled": {
                return Optional.ofNullable(clazz.cast(this.searchEnabled()));
            }
            case "ReturnEnabled": {
                return Optional.ofNullable(clazz.cast(this.returnEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("SourceFields", SOURCE_FIELDS_FIELD);
        map.put("FacetEnabled", FACET_ENABLED_FIELD);
        map.put("SearchEnabled", SEARCH_ENABLED_FIELD);
        map.put("ReturnEnabled", RETURN_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LiteralArrayOptions, T> g) {
        return obj -> g.apply((LiteralArrayOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private String sourceFields;
        private Boolean facetEnabled;
        private Boolean searchEnabled;
        private Boolean returnEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(LiteralArrayOptions model) {
            this.defaultValue(model.defaultValue);
            this.sourceFields(model.sourceFields);
            this.facetEnabled(model.facetEnabled);
            this.searchEnabled(model.searchEnabled);
            this.returnEnabled(model.returnEnabled);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getSourceFields() {
            return this.sourceFields;
        }

        public final void setSourceFields(String sourceFields) {
            this.sourceFields = sourceFields;
        }

        @Override
        public final Builder sourceFields(String sourceFields) {
            this.sourceFields = sourceFields;
            return this;
        }

        public final Boolean getFacetEnabled() {
            return this.facetEnabled;
        }

        public final void setFacetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
        }

        @Override
        public final Builder facetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
            return this;
        }

        public final Boolean getSearchEnabled() {
            return this.searchEnabled;
        }

        public final void setSearchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
        }

        @Override
        public final Builder searchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
            return this;
        }

        public final Boolean getReturnEnabled() {
            return this.returnEnabled;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public LiteralArrayOptions build() {
            return new LiteralArrayOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LiteralArrayOptions> {
        public Builder defaultValue(String var1);

        public Builder sourceFields(String var1);

        public Builder facetEnabled(Boolean var1);

        public Builder searchEnabled(Boolean var1);

        public Builder returnEnabled(Boolean var1);
    }
}

