/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.CloudFrontKeyValueStoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutKeyRequest
extends CloudFrontKeyValueStoreRequest
implements ToCopyableBuilder<Builder, PutKeyRequest> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(PutKeyRequest.getter(PutKeyRequest::key)).setter(PutKeyRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Key").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(PutKeyRequest.getter(PutKeyRequest::value)).setter(PutKeyRequest.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> KVS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KvsARN").getter(PutKeyRequest.getter(PutKeyRequest::kvsARN)).setter(PutKeyRequest.setter(Builder::kvsARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("KvsARN").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(PutKeyRequest.getter(PutKeyRequest::ifMatch)).setter(PutKeyRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD, KVS_ARN_FIELD, IF_MATCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutKeyRequest.memberNameToFieldInitializer();
    private final String key;
    private final String value;
    private final String kvsARN;
    private final String ifMatch;

    private PutKeyRequest(BuilderImpl builder) {
        super(builder);
        this.key = builder.key;
        this.value = builder.value;
        this.kvsARN = builder.kvsARN;
        this.ifMatch = builder.ifMatch;
    }

    public final String key() {
        return this.key;
    }

    public final String value() {
        return this.value;
    }

    public final String kvsARN() {
        return this.kvsARN;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.kvsARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutKeyRequest)) {
            return false;
        }
        PutKeyRequest other = (PutKeyRequest)((Object)obj);
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.kvsARN(), other.kvsARN()) && Objects.equals(this.ifMatch(), other.ifMatch());
    }

    public final String toString() {
        return ToString.builder((String)"PutKeyRequest").add("Key", (Object)this.key()).add("Value", (Object)(this.value() == null ? null : "*** Sensitive Data Redacted ***")).add("KvsARN", (Object)this.kvsARN()).add("IfMatch", (Object)this.ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "KvsARN": {
                return Optional.ofNullable(clazz.cast(this.kvsARN()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Key", KEY_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("KvsARN", KVS_ARN_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutKeyRequest, T> g) {
        return obj -> g.apply((PutKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontKeyValueStoreRequest.BuilderImpl
    implements Builder {
        private String key;
        private String value;
        private String kvsARN;
        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(PutKeyRequest model) {
            super(model);
            this.key(model.key);
            this.value(model.value);
            this.kvsARN(model.kvsARN);
            this.ifMatch(model.ifMatch);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getKvsARN() {
            return this.kvsARN;
        }

        public final void setKvsARN(String kvsARN) {
            this.kvsARN = kvsARN;
        }

        @Override
        public final Builder kvsARN(String kvsARN) {
            this.kvsARN = kvsARN;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutKeyRequest build() {
            return new PutKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontKeyValueStoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutKeyRequest> {
        public Builder key(String var1);

        public Builder value(String var1);

        public Builder kvsARN(String var1);

        public Builder ifMatch(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

