/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionFunctionResponse;

public class ListDistributionsByConnectionFunctionIterable
implements SdkIterable<ListDistributionsByConnectionFunctionResponse> {
    private final CloudFrontClient client;
    private final ListDistributionsByConnectionFunctionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDistributionsByConnectionFunctionIterable(CloudFrontClient client, ListDistributionsByConnectionFunctionRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDistributionsByConnectionFunctionResponseFetcher();
    }

    public Iterator<ListDistributionsByConnectionFunctionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DistributionSummary> items() {
        Function<ListDistributionsByConnectionFunctionResponse, Iterator> getIterator = response -> {
            if (response != null && response.distributionList() != null && response.distributionList().items() != null) {
                return response.distributionList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDistributionsByConnectionFunctionResponseFetcher
    implements SyncPageFetcher<ListDistributionsByConnectionFunctionResponse> {
        private ListDistributionsByConnectionFunctionResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionsByConnectionFunctionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.distributionList().nextMarker());
        }

        public ListDistributionsByConnectionFunctionResponse nextPage(ListDistributionsByConnectionFunctionResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionsByConnectionFunctionIterable.this.client.listDistributionsByConnectionFunction(ListDistributionsByConnectionFunctionIterable.this.firstRequest);
            }
            return ListDistributionsByConnectionFunctionIterable.this.client.listDistributionsByConnectionFunction((ListDistributionsByConnectionFunctionRequest)((Object)ListDistributionsByConnectionFunctionIterable.this.firstRequest.toBuilder().marker(previousPage.distributionList().nextMarker()).build()));
        }
    }
}

