/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CaCertificatesBundleSource;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrustStoreRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, UpdateTrustStoreRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateTrustStoreRequest.getter(UpdateTrustStoreRequest::id)).setter(UpdateTrustStoreRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<CaCertificatesBundleSource> CA_CERTIFICATES_BUNDLE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CaCertificatesBundleSource").getter(UpdateTrustStoreRequest.getter(UpdateTrustStoreRequest::caCertificatesBundleSource)).setter(UpdateTrustStoreRequest.setter(Builder::caCertificatesBundleSource)).constructor(CaCertificatesBundleSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificatesBundleSource").unmarshallLocationName("CaCertificatesBundleSource").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(UpdateTrustStoreRequest.getter(UpdateTrustStoreRequest::ifMatch)).setter(UpdateTrustStoreRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").unmarshallLocationName("If-Match").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CA_CERTIFICATES_BUNDLE_SOURCE_FIELD, IF_MATCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTrustStoreRequest.memberNameToFieldInitializer();
    private final String id;
    private final CaCertificatesBundleSource caCertificatesBundleSource;
    private final String ifMatch;

    private UpdateTrustStoreRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.caCertificatesBundleSource = builder.caCertificatesBundleSource;
        this.ifMatch = builder.ifMatch;
    }

    public final String id() {
        return this.id;
    }

    public final CaCertificatesBundleSource caCertificatesBundleSource() {
        return this.caCertificatesBundleSource;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificatesBundleSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustStoreRequest)) {
            return false;
        }
        UpdateTrustStoreRequest other = (UpdateTrustStoreRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.caCertificatesBundleSource(), other.caCertificatesBundleSource()) && Objects.equals(this.ifMatch(), other.ifMatch());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTrustStoreRequest").add("Id", (Object)this.id()).add("CaCertificatesBundleSource", (Object)this.caCertificatesBundleSource()).add("IfMatch", (Object)this.ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "CaCertificatesBundleSource": {
                return Optional.ofNullable(clazz.cast(this.caCertificatesBundleSource()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("CaCertificatesBundleSource", CA_CERTIFICATES_BUNDLE_SOURCE_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrustStoreRequest, T> g) {
        return obj -> g.apply((UpdateTrustStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String id;
        private CaCertificatesBundleSource caCertificatesBundleSource;
        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrustStoreRequest model) {
            super(model);
            this.id(model.id);
            this.caCertificatesBundleSource(model.caCertificatesBundleSource);
            this.ifMatch(model.ifMatch);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final CaCertificatesBundleSource.Builder getCaCertificatesBundleSource() {
            return this.caCertificatesBundleSource != null ? this.caCertificatesBundleSource.toBuilder() : null;
        }

        public final void setCaCertificatesBundleSource(CaCertificatesBundleSource.BuilderImpl caCertificatesBundleSource) {
            this.caCertificatesBundleSource = caCertificatesBundleSource != null ? caCertificatesBundleSource.build() : null;
        }

        @Override
        public final Builder caCertificatesBundleSource(CaCertificatesBundleSource caCertificatesBundleSource) {
            this.caCertificatesBundleSource = caCertificatesBundleSource;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrustStoreRequest build() {
            return new UpdateTrustStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrustStoreRequest> {
        public Builder id(String var1);

        public Builder caCertificatesBundleSource(CaCertificatesBundleSource var1);

        default public Builder caCertificatesBundleSource(Consumer<CaCertificatesBundleSource.Builder> caCertificatesBundleSource) {
            return this.caCertificatesBundleSource((CaCertificatesBundleSource)((CaCertificatesBundleSource.Builder)CaCertificatesBundleSource.builder().applyMutation(caCertificatesBundleSource)).build());
        }

        public Builder ifMatch(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

