/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.FunctionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectionFunctionRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, UpdateConnectionFunctionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateConnectionFunctionRequest.getter(UpdateConnectionFunctionRequest::id)).setter(UpdateConnectionFunctionRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(UpdateConnectionFunctionRequest.getter(UpdateConnectionFunctionRequest::ifMatch)).setter(UpdateConnectionFunctionRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").unmarshallLocationName("If-Match").build()}).build();
    private static final SdkField<FunctionConfig> CONNECTION_FUNCTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionFunctionConfig").getter(UpdateConnectionFunctionRequest.getter(UpdateConnectionFunctionRequest::connectionFunctionConfig)).setter(UpdateConnectionFunctionRequest.setter(Builder::connectionFunctionConfig)).constructor(FunctionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionConfig").unmarshallLocationName("ConnectionFunctionConfig").build()}).build();
    private static final SdkField<SdkBytes> CONNECTION_FUNCTION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("ConnectionFunctionCode").getter(UpdateConnectionFunctionRequest.getter(UpdateConnectionFunctionRequest::connectionFunctionCode)).setter(UpdateConnectionFunctionRequest.setter(Builder::connectionFunctionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionCode").unmarshallLocationName("ConnectionFunctionCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, IF_MATCH_FIELD, CONNECTION_FUNCTION_CONFIG_FIELD, CONNECTION_FUNCTION_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConnectionFunctionRequest.memberNameToFieldInitializer();
    private final String id;
    private final String ifMatch;
    private final FunctionConfig connectionFunctionConfig;
    private final SdkBytes connectionFunctionCode;

    private UpdateConnectionFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
        this.connectionFunctionConfig = builder.connectionFunctionConfig;
        this.connectionFunctionCode = builder.connectionFunctionCode;
    }

    public final String id() {
        return this.id;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    public final FunctionConfig connectionFunctionConfig() {
        return this.connectionFunctionConfig;
    }

    public final SdkBytes connectionFunctionCode() {
        return this.connectionFunctionCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionFunctionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionFunctionCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionFunctionRequest)) {
            return false;
        }
        UpdateConnectionFunctionRequest other = (UpdateConnectionFunctionRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.ifMatch(), other.ifMatch()) && Objects.equals(this.connectionFunctionConfig(), other.connectionFunctionConfig()) && Objects.equals(this.connectionFunctionCode(), other.connectionFunctionCode());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectionFunctionRequest").add("Id", (Object)this.id()).add("IfMatch", (Object)this.ifMatch()).add("ConnectionFunctionConfig", (Object)this.connectionFunctionConfig()).add("ConnectionFunctionCode", (Object)(this.connectionFunctionCode() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
            case "ConnectionFunctionConfig": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionConfig()));
            }
            case "ConnectionFunctionCode": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        map.put("ConnectionFunctionConfig", CONNECTION_FUNCTION_CONFIG_FIELD);
        map.put("ConnectionFunctionCode", CONNECTION_FUNCTION_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionFunctionRequest, T> g) {
        return obj -> g.apply((UpdateConnectionFunctionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String id;
        private String ifMatch;
        private FunctionConfig connectionFunctionConfig;
        private SdkBytes connectionFunctionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionFunctionRequest model) {
            super(model);
            this.id(model.id);
            this.ifMatch(model.ifMatch);
            this.connectionFunctionConfig(model.connectionFunctionConfig);
            this.connectionFunctionCode(model.connectionFunctionCode);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final FunctionConfig.Builder getConnectionFunctionConfig() {
            return this.connectionFunctionConfig != null ? this.connectionFunctionConfig.toBuilder() : null;
        }

        public final void setConnectionFunctionConfig(FunctionConfig.BuilderImpl connectionFunctionConfig) {
            this.connectionFunctionConfig = connectionFunctionConfig != null ? connectionFunctionConfig.build() : null;
        }

        @Override
        public final Builder connectionFunctionConfig(FunctionConfig connectionFunctionConfig) {
            this.connectionFunctionConfig = connectionFunctionConfig;
            return this;
        }

        public final ByteBuffer getConnectionFunctionCode() {
            return this.connectionFunctionCode == null ? null : this.connectionFunctionCode.asByteBuffer();
        }

        public final void setConnectionFunctionCode(ByteBuffer connectionFunctionCode) {
            this.connectionFunctionCode(connectionFunctionCode == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)connectionFunctionCode));
        }

        @Override
        public final Builder connectionFunctionCode(SdkBytes connectionFunctionCode) {
            this.connectionFunctionCode = connectionFunctionCode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectionFunctionRequest build() {
            return new UpdateConnectionFunctionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConnectionFunctionRequest> {
        public Builder id(String var1);

        public Builder ifMatch(String var1);

        public Builder connectionFunctionConfig(FunctionConfig var1);

        default public Builder connectionFunctionConfig(Consumer<FunctionConfig.Builder> connectionFunctionConfig) {
            return this.connectionFunctionConfig((FunctionConfig)((FunctionConfig.Builder)FunctionConfig.builder().applyMutation(connectionFunctionConfig)).build());
        }

        public Builder connectionFunctionCode(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

