/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsResponse;

public class ListDistributionTenantsIterable
implements SdkIterable<ListDistributionTenantsResponse> {
    private final CloudFrontClient client;
    private final ListDistributionTenantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDistributionTenantsIterable(CloudFrontClient client, ListDistributionTenantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDistributionTenantsResponseFetcher();
    }

    public Iterator<ListDistributionTenantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DistributionTenantSummary> distributionTenantList() {
        Function<ListDistributionTenantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.distributionTenantList() != null) {
                return response.distributionTenantList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDistributionTenantsResponseFetcher
    implements SyncPageFetcher<ListDistributionTenantsResponse> {
        private ListDistributionTenantsResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionTenantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListDistributionTenantsResponse nextPage(ListDistributionTenantsResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionTenantsIterable.this.client.listDistributionTenants(ListDistributionTenantsIterable.this.firstRequest);
            }
            return ListDistributionTenantsIterable.this.client.listDistributionTenants((ListDistributionTenantsRequest)((Object)ListDistributionTenantsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

