/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.InvalidationBatch;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInvalidationRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateInvalidationRequest> {
    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistributionId").getter(CreateInvalidationRequest.getter(CreateInvalidationRequest::distributionId)).setter(CreateInvalidationRequest.setter(Builder::distributionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DistributionId").unmarshallLocationName("DistributionId").build()}).build();
    private static final SdkField<InvalidationBatch> INVALIDATION_BATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InvalidationBatch").getter(CreateInvalidationRequest.getter(CreateInvalidationRequest::invalidationBatch)).setter(CreateInvalidationRequest.setter(Builder::invalidationBatch)).constructor(InvalidationBatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidationBatch").unmarshallLocationName("InvalidationBatch").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_ID_FIELD, INVALIDATION_BATCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateInvalidationRequest.memberNameToFieldInitializer();
    private final String distributionId;
    private final InvalidationBatch invalidationBatch;

    private CreateInvalidationRequest(BuilderImpl builder) {
        super(builder);
        this.distributionId = builder.distributionId;
        this.invalidationBatch = builder.invalidationBatch;
    }

    public final String distributionId() {
        return this.distributionId;
    }

    public final InvalidationBatch invalidationBatch() {
        return this.invalidationBatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidationBatch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvalidationRequest)) {
            return false;
        }
        CreateInvalidationRequest other = (CreateInvalidationRequest)((Object)obj);
        return Objects.equals(this.distributionId(), other.distributionId()) && Objects.equals(this.invalidationBatch(), other.invalidationBatch());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInvalidationRequest").add("DistributionId", (Object)this.distributionId()).add("InvalidationBatch", (Object)this.invalidationBatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributionId": {
                return Optional.ofNullable(clazz.cast(this.distributionId()));
            }
            case "InvalidationBatch": {
                return Optional.ofNullable(clazz.cast(this.invalidationBatch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DistributionId", DISTRIBUTION_ID_FIELD);
        map.put("InvalidationBatch", INVALIDATION_BATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInvalidationRequest, T> g) {
        return obj -> g.apply((CreateInvalidationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String distributionId;
        private InvalidationBatch invalidationBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvalidationRequest model) {
            super(model);
            this.distributionId(model.distributionId);
            this.invalidationBatch(model.invalidationBatch);
        }

        public final String getDistributionId() {
            return this.distributionId;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final InvalidationBatch.Builder getInvalidationBatch() {
            return this.invalidationBatch != null ? this.invalidationBatch.toBuilder() : null;
        }

        public final void setInvalidationBatch(InvalidationBatch.BuilderImpl invalidationBatch) {
            this.invalidationBatch = invalidationBatch != null ? invalidationBatch.build() : null;
        }

        @Override
        public final Builder invalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInvalidationRequest build() {
            return new CreateInvalidationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInvalidationRequest> {
        public Builder distributionId(String var1);

        public Builder invalidationBatch(InvalidationBatch var1);

        default public Builder invalidationBatch(Consumer<InvalidationBatch.Builder> invalidationBatch) {
            return this.invalidationBatch((InvalidationBatch)((InvalidationBatch.Builder)InvalidationBatch.builder().applyMutation(invalidationBatch)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

