/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to list distributions that are associated with a specified WAF web ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDistributionsByWebAclIdRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListDistributionsByWebAclIdRequest.Builder, ListDistributionsByWebAclIdRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListDistributionsByWebAclIdRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListDistributionsByWebAclIdRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WebACLId")
            .getter(getter(ListDistributionsByWebAclIdRequest::webACLId))
            .setter(setter(Builder::webACLId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("WebACLId")
                    .unmarshallLocationName("WebACLId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, MAX_ITEMS_FIELD,
            WEB_ACL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final String maxItems;

    private final String webACLId;

    private ListDistributionsByWebAclIdRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.webACLId = builder.webACLId;
    }

    /**
     * <p>
     * Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than
     * <code>MaxItems</code> distributions that satisfy the request, the response includes a <code>NextMarker</code>
     * element. To get the next page of results, submit another request. For the value of <code>Marker</code>, specify
     * the value of <code>NextMarker</code> from the last response. (For the first request, omit <code>Marker</code>.)
     * </p>
     * 
     * @return Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than
     *         <code>MaxItems</code> distributions that satisfy the request, the response includes a
     *         <code>NextMarker</code> element. To get the next page of results, submit another request. For the value
     *         of <code>Marker</code>, specify the value of <code>NextMarker</code> from the last response. (For the
     *         first request, omit <code>Marker</code>.)
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of distributions that you want CloudFront to return in the response body. The maximum and
     * default values are both 100.
     * </p>
     * 
     * @return The maximum number of distributions that you want CloudFront to return in the response body. The maximum
     *         and default values are both 100.
     */
    public final String maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the ID,
     * the request returns a list of the distributions that aren't associated with a web ACL.
     * </p>
     * <p>
     * For WAFV2, this is the ARN of the web ACL, such as
     * <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
     * .
     * </p>
     * <p>
     * For WAF Classic, this is the ID of the web ACL, such as <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>.
     * </p>
     * 
     * @return The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for
     *         the ID, the request returns a list of the distributions that aren't associated with a web ACL. </p>
     *         <p>
     *         For WAFV2, this is the ARN of the web ACL, such as
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
     *         .
     *         </p>
     *         <p>
     *         For WAF Classic, this is the ID of the web ACL, such as <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>.
     */
    public final String webACLId() {
        return webACLId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(webACLId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByWebAclIdRequest)) {
            return false;
        }
        ListDistributionsByWebAclIdRequest other = (ListDistributionsByWebAclIdRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(webACLId(), other.webACLId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDistributionsByWebAclIdRequest").add("Marker", marker()).add("MaxItems", maxItems())
                .add("WebACLId", webACLId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "WebACLId":
            return Optional.ofNullable(clazz.cast(webACLId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("WebACLId", WEB_ACL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByWebAclIdRequest, T> g) {
        return obj -> g.apply((ListDistributionsByWebAclIdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDistributionsByWebAclIdRequest> {
        /**
         * <p>
         * Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than
         * <code>MaxItems</code> distributions that satisfy the request, the response includes a <code>NextMarker</code>
         * element. To get the next page of results, submit another request. For the value of <code>Marker</code>,
         * specify the value of <code>NextMarker</code> from the last response. (For the first request, omit
         * <code>Marker</code>.)
         * </p>
         * 
         * @param marker
         *        Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more
         *        than <code>MaxItems</code> distributions that satisfy the request, the response includes a
         *        <code>NextMarker</code> element. To get the next page of results, submit another request. For the
         *        value of <code>Marker</code>, specify the value of <code>NextMarker</code> from the last response.
         *        (For the first request, omit <code>Marker</code>.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of distributions that you want CloudFront to return in the response body. The maximum and
         * default values are both 100.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of distributions that you want CloudFront to return in the response body. The
         *        maximum and default values are both 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        /**
         * <p>
         * The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the
         * ID, the request returns a list of the distributions that aren't associated with a web ACL.
         * </p>
         * <p>
         * For WAFV2, this is the ARN of the web ACL, such as
         * <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
         * .
         * </p>
         * <p>
         * For WAF Classic, this is the ID of the web ACL, such as <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>.
         * </p>
         * 
         * @param webACLId
         *        The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null"
         *        for the ID, the request returns a list of the distributions that aren't associated with a web ACL.
         *        </p>
         *        <p>
         *        For WAFV2, this is the ARN of the web ACL, such as
         *        <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
         *        .
         *        </p>
         *        <p>
         *        For WAF Classic, this is the ID of the web ACL, such as
         *        <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLId(String webACLId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private String webACLId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByWebAclIdRequest model) {
            super(model);
            marker(model.marker);
            maxItems(model.maxItems);
            webACLId(model.webACLId);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getWebACLId() {
            return webACLId;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDistributionsByWebAclIdRequest build() {
            return new ListDistributionsByWebAclIdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
