/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDistributionsByRealtimeLogConfigRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListDistributionsByRealtimeLogConfigRequest.Builder, ListDistributionsByRealtimeLogConfigRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListDistributionsByRealtimeLogConfigRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListDistributionsByRealtimeLogConfigRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<String> REALTIME_LOG_CONFIG_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RealtimeLogConfigName")
            .getter(getter(ListDistributionsByRealtimeLogConfigRequest::realtimeLogConfigName))
            .setter(setter(Builder::realtimeLogConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeLogConfigName")
                    .unmarshallLocationName("RealtimeLogConfigName").build()).build();

    private static final SdkField<String> REALTIME_LOG_CONFIG_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RealtimeLogConfigArn")
            .getter(getter(ListDistributionsByRealtimeLogConfigRequest::realtimeLogConfigArn))
            .setter(setter(Builder::realtimeLogConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeLogConfigArn")
                    .unmarshallLocationName("RealtimeLogConfigArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, MAX_ITEMS_FIELD,
            REALTIME_LOG_CONFIG_NAME_FIELD, REALTIME_LOG_CONFIG_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final String maxItems;

    private final String realtimeLogConfigName;

    private final String realtimeLogConfigArn;

    private ListDistributionsByRealtimeLogConfigRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.realtimeLogConfigName = builder.realtimeLogConfigName;
        this.realtimeLogConfigArn = builder.realtimeLogConfigArn;
    }

    /**
     * <p>
     * Use this field when paginating results to indicate where to begin in your list of distributions. The response
     * includes distributions in the list that occur after the marker. To get the next page of the list, set this
     * field's value to the value of <code>NextMarker</code> from the current page's response.
     * </p>
     * 
     * @return Use this field when paginating results to indicate where to begin in your list of distributions. The
     *         response includes distributions in the list that occur after the marker. To get the next page of the
     *         list, set this field's value to the value of <code>NextMarker</code> from the current page's response.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of distributions that you want in the response.
     * </p>
     * 
     * @return The maximum number of distributions that you want in the response.
     */
    public final String maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The name of the real-time log configuration whose associated distributions you want to list.
     * </p>
     * 
     * @return The name of the real-time log configuration whose associated distributions you want to list.
     */
    public final String realtimeLogConfigName() {
        return realtimeLogConfigName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you want to
     * list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you want
     *         to list.
     */
    public final String realtimeLogConfigArn() {
        return realtimeLogConfigArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(realtimeLogConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(realtimeLogConfigArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByRealtimeLogConfigRequest)) {
            return false;
        }
        ListDistributionsByRealtimeLogConfigRequest other = (ListDistributionsByRealtimeLogConfigRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(realtimeLogConfigName(), other.realtimeLogConfigName())
                && Objects.equals(realtimeLogConfigArn(), other.realtimeLogConfigArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDistributionsByRealtimeLogConfigRequest").add("Marker", marker())
                .add("MaxItems", maxItems()).add("RealtimeLogConfigName", realtimeLogConfigName())
                .add("RealtimeLogConfigArn", realtimeLogConfigArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "RealtimeLogConfigName":
            return Optional.ofNullable(clazz.cast(realtimeLogConfigName()));
        case "RealtimeLogConfigArn":
            return Optional.ofNullable(clazz.cast(realtimeLogConfigArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("RealtimeLogConfigName", REALTIME_LOG_CONFIG_NAME_FIELD);
        map.put("RealtimeLogConfigArn", REALTIME_LOG_CONFIG_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByRealtimeLogConfigRequest, T> g) {
        return obj -> g.apply((ListDistributionsByRealtimeLogConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDistributionsByRealtimeLogConfigRequest> {
        /**
         * <p>
         * Use this field when paginating results to indicate where to begin in your list of distributions. The response
         * includes distributions in the list that occur after the marker. To get the next page of the list, set this
         * field's value to the value of <code>NextMarker</code> from the current page's response.
         * </p>
         * 
         * @param marker
         *        Use this field when paginating results to indicate where to begin in your list of distributions. The
         *        response includes distributions in the list that occur after the marker. To get the next page of the
         *        list, set this field's value to the value of <code>NextMarker</code> from the current page's response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of distributions that you want in the response.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of distributions that you want in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        /**
         * <p>
         * The name of the real-time log configuration whose associated distributions you want to list.
         * </p>
         * 
         * @param realtimeLogConfigName
         *        The name of the real-time log configuration whose associated distributions you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realtimeLogConfigName(String realtimeLogConfigName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you want to
         * list.
         * </p>
         * 
         * @param realtimeLogConfigArn
         *        The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you
         *        want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realtimeLogConfigArn(String realtimeLogConfigArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private String realtimeLogConfigName;

        private String realtimeLogConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByRealtimeLogConfigRequest model) {
            super(model);
            marker(model.marker);
            maxItems(model.maxItems);
            realtimeLogConfigName(model.realtimeLogConfigName);
            realtimeLogConfigArn(model.realtimeLogConfigArn);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getRealtimeLogConfigName() {
            return realtimeLogConfigName;
        }

        public final void setRealtimeLogConfigName(String realtimeLogConfigName) {
            this.realtimeLogConfigName = realtimeLogConfigName;
        }

        @Override
        public final Builder realtimeLogConfigName(String realtimeLogConfigName) {
            this.realtimeLogConfigName = realtimeLogConfigName;
            return this;
        }

        public final String getRealtimeLogConfigArn() {
            return realtimeLogConfigArn;
        }

        public final void setRealtimeLogConfigArn(String realtimeLogConfigArn) {
            this.realtimeLogConfigArn = realtimeLogConfigArn;
        }

        @Override
        public final Builder realtimeLogConfigArn(String realtimeLogConfigArn) {
            this.realtimeLogConfigArn = realtimeLogConfigArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDistributionsByRealtimeLogConfigRequest build() {
            return new ListDistributionsByRealtimeLogConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
