/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectionGroupByRoutingEndpointRequest extends CloudFrontRequest implements
        ToCopyableBuilder<GetConnectionGroupByRoutingEndpointRequest.Builder, GetConnectionGroupByRoutingEndpointRequest> {
    private static final SdkField<String> ROUTING_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RoutingEndpoint")
            .getter(getter(GetConnectionGroupByRoutingEndpointRequest::routingEndpoint))
            .setter(setter(Builder::routingEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RoutingEndpoint")
                    .unmarshallLocationName("RoutingEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String routingEndpoint;

    private GetConnectionGroupByRoutingEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.routingEndpoint = builder.routingEndpoint;
    }

    /**
     * <p>
     * The routing endpoint for the target connection group, such as d111111abcdef8.cloudfront.net.
     * </p>
     * 
     * @return The routing endpoint for the target connection group, such as d111111abcdef8.cloudfront.net.
     */
    public final String routingEndpoint() {
        return routingEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routingEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionGroupByRoutingEndpointRequest)) {
            return false;
        }
        GetConnectionGroupByRoutingEndpointRequest other = (GetConnectionGroupByRoutingEndpointRequest) obj;
        return Objects.equals(routingEndpoint(), other.routingEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectionGroupByRoutingEndpointRequest").add("RoutingEndpoint", routingEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoutingEndpoint":
            return Optional.ofNullable(clazz.cast(routingEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoutingEndpoint", ROUTING_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionGroupByRoutingEndpointRequest, T> g) {
        return obj -> g.apply((GetConnectionGroupByRoutingEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConnectionGroupByRoutingEndpointRequest> {
        /**
         * <p>
         * The routing endpoint for the target connection group, such as d111111abcdef8.cloudfront.net.
         * </p>
         * 
         * @param routingEndpoint
         *        The routing endpoint for the target connection group, such as d111111abcdef8.cloudfront.net.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingEndpoint(String routingEndpoint);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String routingEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionGroupByRoutingEndpointRequest model) {
            super(model);
            routingEndpoint(model.routingEndpoint);
        }

        public final String getRoutingEndpoint() {
            return routingEndpoint;
        }

        public final void setRoutingEndpoint(String routingEndpoint) {
            this.routingEndpoint = routingEndpoint;
        }

        @Override
        public final Builder routingEndpoint(String routingEndpoint) {
            this.routingEndpoint = routingEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConnectionGroupByRoutingEndpointRequest build() {
            return new GetConnectionGroupByRoutingEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
