/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The distribution tenant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DistributionTenant implements SdkPojo, Serializable,
        ToCopyableBuilder<DistributionTenant.Builder, DistributionTenant> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(DistributionTenant::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DistributionId")
            .getter(getter(DistributionTenant::distributionId))
            .setter(setter(Builder::distributionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionId")
                    .unmarshallLocationName("DistributionId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(DistributionTenant::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Arn")
            .getter(getter(DistributionTenant::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn")
                    .build()).build();

    private static final SdkField<List<DomainResult>> DOMAINS_FIELD = SdkField
            .<List<DomainResult>> builder(MarshallingType.LIST)
            .memberName("Domains")
            .getter(getter(DistributionTenant::domains))
            .setter(setter(Builder::domains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains")
                    .unmarshallLocationName("Domains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Tags> TAGS_FIELD = SdkField
            .<Tags> builder(MarshallingType.SDK_POJO)
            .memberName("Tags")
            .getter(getter(DistributionTenant::tags))
            .setter(setter(Builder::tags))
            .constructor(Tags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags")
                    .unmarshallLocationName("Tags").build()).build();

    private static final SdkField<Customizations> CUSTOMIZATIONS_FIELD = SdkField
            .<Customizations> builder(MarshallingType.SDK_POJO)
            .memberName("Customizations")
            .getter(getter(DistributionTenant::customizations))
            .setter(setter(Builder::customizations))
            .constructor(Customizations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customizations")
                    .unmarshallLocationName("Customizations").build()).build();

    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(DistributionTenant::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters")
                    .unmarshallLocationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<String> CONNECTION_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionGroupId")
            .getter(getter(DistributionTenant::connectionGroupId))
            .setter(setter(Builder::connectionGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionGroupId")
                    .unmarshallLocationName("ConnectionGroupId").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime")
            .getter(getter(DistributionTenant::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime")
                    .unmarshallLocationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(DistributionTenant::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(DistributionTenant::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(DistributionTenant::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            DISTRIBUTION_ID_FIELD, NAME_FIELD, ARN_FIELD, DOMAINS_FIELD, TAGS_FIELD, CUSTOMIZATIONS_FIELD, PARAMETERS_FIELD,
            CONNECTION_GROUP_ID_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ENABLED_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String distributionId;

    private final String name;

    private final String arn;

    private final List<DomainResult> domains;

    private final Tags tags;

    private final Customizations customizations;

    private final List<Parameter> parameters;

    private final String connectionGroupId;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private final Boolean enabled;

    private final String status;

    private DistributionTenant(BuilderImpl builder) {
        this.id = builder.id;
        this.distributionId = builder.distributionId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.domains = builder.domains;
        this.tags = builder.tags;
        this.customizations = builder.customizations;
        this.parameters = builder.parameters;
        this.connectionGroupId = builder.connectionGroupId;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.enabled = builder.enabled;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the distribution tenant.
     * </p>
     * 
     * @return The ID of the distribution tenant.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the multi-tenant distribution.
     * </p>
     * 
     * @return The ID of the multi-tenant distribution.
     */
    public final String distributionId() {
        return distributionId;
    }

    /**
     * <p>
     * The name of the distribution tenant.
     * </p>
     * 
     * @return The name of the distribution tenant.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the distribution tenant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the distribution tenant.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Domains property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDomains() {
        return domains != null && !(domains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domains associated with the distribution tenant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomains} method.
     * </p>
     * 
     * @return The domains associated with the distribution tenant.
     */
    public final List<DomainResult> domains() {
        return domains;
    }

    /**
     * Returns the value of the Tags property for this object.
     * 
     * @return The value of the Tags property for this object.
     */
    public final Tags tags() {
        return tags;
    }

    /**
     * <p>
     * Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic
     * restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are specific
     * values that you can override or disable from the multi-tenant distribution that was used to create the
     * distribution tenant.
     * </p>
     * 
     * @return Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic
     *         restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are
     *         specific values that you can override or disable from the multi-tenant distribution that was used to
     *         create the distribution tenant.
     */
    public final Customizations customizations() {
        return customizations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid
     * parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid
     *         parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
     */
    public final List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The ID of the connection group for the distribution tenant. If you don't specify a connection group, CloudFront
     * uses the default connection group.
     * </p>
     * 
     * @return The ID of the connection group for the distribution tenant. If you don't specify a connection group,
     *         CloudFront uses the default connection group.
     */
    public final String connectionGroupId() {
        return connectionGroupId;
    }

    /**
     * <p>
     * The date and time when the distribution tenant was created.
     * </p>
     * 
     * @return The date and time when the distribution tenant was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date and time when the distribution tenant was updated.
     * </p>
     * 
     * @return The date and time when the distribution tenant was updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Indicates whether the distribution tenant is in an enabled state. If disabled, the distribution tenant won't
     * serve traffic.
     * </p>
     * 
     * @return Indicates whether the distribution tenant is in an enabled state. If disabled, the distribution tenant
     *         won't serve traffic.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The status of the distribution tenant.
     * </p>
     * 
     * @return The status of the distribution tenant.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomains() ? domains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(customizations());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionTenant)) {
            return false;
        }
        DistributionTenant other = (DistributionTenant) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(distributionId(), other.distributionId())
                && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && hasDomains() == other.hasDomains() && Objects.equals(domains(), other.domains())
                && Objects.equals(tags(), other.tags()) && Objects.equals(customizations(), other.customizations())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(connectionGroupId(), other.connectionGroupId())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DistributionTenant").add("Id", id()).add("DistributionId", distributionId()).add("Name", name())
                .add("Arn", arn()).add("Domains", hasDomains() ? domains() : null).add("Tags", tags())
                .add("Customizations", customizations()).add("Parameters", hasParameters() ? parameters() : null)
                .add("ConnectionGroupId", connectionGroupId()).add("CreatedTime", createdTime())
                .add("LastModifiedTime", lastModifiedTime()).add("Enabled", enabled()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "DistributionId":
            return Optional.ofNullable(clazz.cast(distributionId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Domains":
            return Optional.ofNullable(clazz.cast(domains()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Customizations":
            return Optional.ofNullable(clazz.cast(customizations()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ConnectionGroupId":
            return Optional.ofNullable(clazz.cast(connectionGroupId()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("DistributionId", DISTRIBUTION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Domains", DOMAINS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Customizations", CUSTOMIZATIONS_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("ConnectionGroupId", CONNECTION_GROUP_ID_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DistributionTenant, T> g) {
        return obj -> g.apply((DistributionTenant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DistributionTenant> {
        /**
         * <p>
         * The ID of the distribution tenant.
         * </p>
         * 
         * @param id
         *        The ID of the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the multi-tenant distribution.
         * </p>
         * 
         * @param distributionId
         *        The ID of the multi-tenant distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionId(String distributionId);

        /**
         * <p>
         * The name of the distribution tenant.
         * </p>
         * 
         * @param name
         *        The name of the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the distribution tenant.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The domains associated with the distribution tenant.
         * </p>
         * 
         * @param domains
         *        The domains associated with the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<DomainResult> domains);

        /**
         * <p>
         * The domains associated with the distribution tenant.
         * </p>
         * 
         * @param domains
         *        The domains associated with the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(DomainResult... domains);

        /**
         * <p>
         * The domains associated with the distribution tenant.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.DomainResult.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudfront.model.DomainResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.DomainResult.Builder#build()} is called immediately
         * and its result is passed to {@link #domains(List<DomainResult>)}.
         * 
         * @param domains
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.DomainResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domains(java.util.Collection<DomainResult>)
         */
        Builder domains(Consumer<DomainResult.Builder>... domains);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tags tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Tags.Builder} avoiding the need to create
         * one manually via {@link Tags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Tags.Builder#build()} is called immediately and its result is
         * passed to {@link #tags(Tags)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link Tags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(Tags)
         */
        default Builder tags(Consumer<Tags.Builder> tags) {
            return tags(Tags.builder().applyMutation(tags).build());
        }

        /**
         * <p>
         * Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic
         * restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are
         * specific values that you can override or disable from the multi-tenant distribution that was used to create
         * the distribution tenant.
         * </p>
         * 
         * @param customizations
         *        Customizations for the distribution tenant. For each distribution tenant, you can specify the
         *        geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL.
         *        These are specific values that you can override or disable from the multi-tenant distribution that was
         *        used to create the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizations(Customizations customizations);

        /**
         * <p>
         * Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic
         * restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are
         * specific values that you can override or disable from the multi-tenant distribution that was used to create
         * the distribution tenant.
         * </p>
         * This is a convenience method that creates an instance of the {@link Customizations.Builder} avoiding the need
         * to create one manually via {@link Customizations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Customizations.Builder#build()} is called immediately and its
         * result is passed to {@link #customizations(Customizations)}.
         * 
         * @param customizations
         *        a consumer that will call methods on {@link Customizations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customizations(Customizations)
         */
        default Builder customizations(Consumer<Customizations.Builder> customizations) {
            return customizations(Customizations.builder().applyMutation(customizations).build());
        }

        /**
         * <p>
         * A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid
         * parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
         * </p>
         * 
         * @param parameters
         *        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A
         *        valid parameter value must exist for any parameter that is marked as required in the multi-tenant
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid
         * parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
         * </p>
         * 
         * @param parameters
         *        A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A
         *        valid parameter value must exist for any parameter that is marked as required in the multi-tenant
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid
         * parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.Parameter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudfront.model.Parameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.Parameter.Builder#build()} is called immediately and
         * its result is passed to {@link #parameters(List<Parameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.Parameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<Parameter>)
         */
        Builder parameters(Consumer<Parameter.Builder>... parameters);

        /**
         * <p>
         * The ID of the connection group for the distribution tenant. If you don't specify a connection group,
         * CloudFront uses the default connection group.
         * </p>
         * 
         * @param connectionGroupId
         *        The ID of the connection group for the distribution tenant. If you don't specify a connection group,
         *        CloudFront uses the default connection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionGroupId(String connectionGroupId);

        /**
         * <p>
         * The date and time when the distribution tenant was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time when the distribution tenant was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The date and time when the distribution tenant was updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time when the distribution tenant was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Indicates whether the distribution tenant is in an enabled state. If disabled, the distribution tenant won't
         * serve traffic.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the distribution tenant is in an enabled state. If disabled, the distribution tenant
         *        won't serve traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The status of the distribution tenant.
         * </p>
         * 
         * @param status
         *        The status of the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String distributionId;

        private String name;

        private String arn;

        private List<DomainResult> domains = DefaultSdkAutoConstructList.getInstance();

        private Tags tags;

        private Customizations customizations;

        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private String connectionGroupId;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private Boolean enabled;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionTenant model) {
            id(model.id);
            distributionId(model.distributionId);
            name(model.name);
            arn(model.arn);
            domains(model.domains);
            tags(model.tags);
            customizations(model.customizations);
            parameters(model.parameters);
            connectionGroupId(model.connectionGroupId);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
            enabled(model.enabled);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDistributionId() {
            return distributionId;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<DomainResult.Builder> getDomains() {
            List<DomainResult.Builder> result = DomainResultListCopier.copyToBuilder(this.domains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomains(Collection<DomainResult.BuilderImpl> domains) {
            this.domains = DomainResultListCopier.copyFromBuilder(domains);
        }

        @Override
        public final Builder domains(Collection<DomainResult> domains) {
            this.domains = DomainResultListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(DomainResult... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Consumer<DomainResult.Builder>... domains) {
            domains(Stream.of(domains).map(c -> DomainResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Tags.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public final Customizations.Builder getCustomizations() {
            return customizations != null ? customizations.toBuilder() : null;
        }

        public final void setCustomizations(Customizations.BuilderImpl customizations) {
            this.customizations = customizations != null ? customizations.build() : null;
        }

        @Override
        public final Builder customizations(Customizations customizations) {
            this.customizations = customizations;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> Parameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConnectionGroupId() {
            return connectionGroupId;
        }

        public final void setConnectionGroupId(String connectionGroupId) {
            this.connectionGroupId = connectionGroupId;
        }

        @Override
        public final Builder connectionGroupId(String connectionGroupId) {
            this.connectionGroupId = connectionGroupId;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public DistributionTenant build() {
            return new DistributionTenant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
