/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The IDs for the distribution resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DistributionResourceId implements SdkPojo, Serializable,
        ToCopyableBuilder<DistributionResourceId.Builder, DistributionResourceId> {
    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DistributionId")
            .getter(getter(DistributionResourceId::distributionId))
            .setter(setter(Builder::distributionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionId")
                    .unmarshallLocationName("DistributionId").build()).build();

    private static final SdkField<String> DISTRIBUTION_TENANT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DistributionTenantId")
            .getter(getter(DistributionResourceId::distributionTenantId))
            .setter(setter(Builder::distributionTenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionTenantId")
                    .unmarshallLocationName("DistributionTenantId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_ID_FIELD,
            DISTRIBUTION_TENANT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String distributionId;

    private final String distributionTenantId;

    private DistributionResourceId(BuilderImpl builder) {
        this.distributionId = builder.distributionId;
        this.distributionTenantId = builder.distributionTenantId;
    }

    /**
     * <p>
     * The ID of the multi-tenant distribution.
     * </p>
     * 
     * @return The ID of the multi-tenant distribution.
     */
    public final String distributionId() {
        return distributionId;
    }

    /**
     * <p>
     * The ID of the distribution tenant.
     * </p>
     * 
     * @return The ID of the distribution tenant.
     */
    public final String distributionTenantId() {
        return distributionTenantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(distributionTenantId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionResourceId)) {
            return false;
        }
        DistributionResourceId other = (DistributionResourceId) obj;
        return Objects.equals(distributionId(), other.distributionId())
                && Objects.equals(distributionTenantId(), other.distributionTenantId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DistributionResourceId").add("DistributionId", distributionId())
                .add("DistributionTenantId", distributionTenantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionId":
            return Optional.ofNullable(clazz.cast(distributionId()));
        case "DistributionTenantId":
            return Optional.ofNullable(clazz.cast(distributionTenantId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DistributionId", DISTRIBUTION_ID_FIELD);
        map.put("DistributionTenantId", DISTRIBUTION_TENANT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DistributionResourceId, T> g) {
        return obj -> g.apply((DistributionResourceId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DistributionResourceId> {
        /**
         * <p>
         * The ID of the multi-tenant distribution.
         * </p>
         * 
         * @param distributionId
         *        The ID of the multi-tenant distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionId(String distributionId);

        /**
         * <p>
         * The ID of the distribution tenant.
         * </p>
         * 
         * @param distributionTenantId
         *        The ID of the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionTenantId(String distributionTenantId);
    }

    static final class BuilderImpl implements Builder {
        private String distributionId;

        private String distributionTenantId;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionResourceId model) {
            distributionId(model.distributionId);
            distributionTenantId(model.distributionTenantId);
        }

        public final String getDistributionId() {
            return distributionId;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final String getDistributionTenantId() {
            return distributionTenantId;
        }

        public final void setDistributionTenantId(String distributionTenantId) {
            this.distributionTenantId = distributionTenantId;
        }

        @Override
        public final Builder distributionTenantId(String distributionTenantId) {
            this.distributionTenantId = distributionTenantId;
            return this;
        }

        @Override
        public DistributionResourceId build() {
            return new DistributionResourceId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
