/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Customizations for the distribution tenant. For each distribution tenant, you can specify the geographic
 * restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and WAF web ACL. These are specific values
 * that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Customizations implements SdkPojo, Serializable, ToCopyableBuilder<Customizations.Builder, Customizations> {
    private static final SdkField<WebAclCustomization> WEB_ACL_FIELD = SdkField
            .<WebAclCustomization> builder(MarshallingType.SDK_POJO)
            .memberName("WebAcl")
            .getter(getter(Customizations::webAcl))
            .setter(setter(Builder::webAcl))
            .constructor(WebAclCustomization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAcl")
                    .unmarshallLocationName("WebAcl").build()).build();

    private static final SdkField<Certificate> CERTIFICATE_FIELD = SdkField
            .<Certificate> builder(MarshallingType.SDK_POJO)
            .memberName("Certificate")
            .getter(getter(Customizations::certificate))
            .setter(setter(Builder::certificate))
            .constructor(Certificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate")
                    .unmarshallLocationName("Certificate").build()).build();

    private static final SdkField<GeoRestrictionCustomization> GEO_RESTRICTIONS_FIELD = SdkField
            .<GeoRestrictionCustomization> builder(MarshallingType.SDK_POJO)
            .memberName("GeoRestrictions")
            .getter(getter(Customizations::geoRestrictions))
            .setter(setter(Builder::geoRestrictions))
            .constructor(GeoRestrictionCustomization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoRestrictions")
                    .unmarshallLocationName("GeoRestrictions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_FIELD,
            CERTIFICATE_FIELD, GEO_RESTRICTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WebAclCustomization webAcl;

    private final Certificate certificate;

    private final GeoRestrictionCustomization geoRestrictions;

    private Customizations(BuilderImpl builder) {
        this.webAcl = builder.webAcl;
        this.certificate = builder.certificate;
        this.geoRestrictions = builder.geoRestrictions;
    }

    /**
     * <p>
     * The WAF web ACL.
     * </p>
     * 
     * @return The WAF web ACL.
     */
    public final WebAclCustomization webAcl() {
        return webAcl;
    }

    /**
     * <p>
     * The Certificate Manager (ACM) certificate.
     * </p>
     * 
     * @return The Certificate Manager (ACM) certificate.
     */
    public final Certificate certificate() {
        return certificate;
    }

    /**
     * <p>
     * The geographic restrictions.
     * </p>
     * 
     * @return The geographic restrictions.
     */
    public final GeoRestrictionCustomization geoRestrictions() {
        return geoRestrictions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(webAcl());
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(geoRestrictions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Customizations)) {
            return false;
        }
        Customizations other = (Customizations) obj;
        return Objects.equals(webAcl(), other.webAcl()) && Objects.equals(certificate(), other.certificate())
                && Objects.equals(geoRestrictions(), other.geoRestrictions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Customizations").add("WebAcl", webAcl()).add("Certificate", certificate())
                .add("GeoRestrictions", geoRestrictions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebAcl":
            return Optional.ofNullable(clazz.cast(webAcl()));
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "GeoRestrictions":
            return Optional.ofNullable(clazz.cast(geoRestrictions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WebAcl", WEB_ACL_FIELD);
        map.put("Certificate", CERTIFICATE_FIELD);
        map.put("GeoRestrictions", GEO_RESTRICTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Customizations, T> g) {
        return obj -> g.apply((Customizations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Customizations> {
        /**
         * <p>
         * The WAF web ACL.
         * </p>
         * 
         * @param webAcl
         *        The WAF web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAcl(WebAclCustomization webAcl);

        /**
         * <p>
         * The WAF web ACL.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebAclCustomization.Builder} avoiding the
         * need to create one manually via {@link WebAclCustomization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebAclCustomization.Builder#build()} is called immediately and
         * its result is passed to {@link #webAcl(WebAclCustomization)}.
         * 
         * @param webAcl
         *        a consumer that will call methods on {@link WebAclCustomization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webAcl(WebAclCustomization)
         */
        default Builder webAcl(Consumer<WebAclCustomization.Builder> webAcl) {
            return webAcl(WebAclCustomization.builder().applyMutation(webAcl).build());
        }

        /**
         * <p>
         * The Certificate Manager (ACM) certificate.
         * </p>
         * 
         * @param certificate
         *        The Certificate Manager (ACM) certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(Certificate certificate);

        /**
         * <p>
         * The Certificate Manager (ACM) certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link Certificate.Builder} avoiding the need to
         * create one manually via {@link Certificate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Certificate.Builder#build()} is called immediately and its result
         * is passed to {@link #certificate(Certificate)}.
         * 
         * @param certificate
         *        a consumer that will call methods on {@link Certificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificate(Certificate)
         */
        default Builder certificate(Consumer<Certificate.Builder> certificate) {
            return certificate(Certificate.builder().applyMutation(certificate).build());
        }

        /**
         * <p>
         * The geographic restrictions.
         * </p>
         * 
         * @param geoRestrictions
         *        The geographic restrictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoRestrictions(GeoRestrictionCustomization geoRestrictions);

        /**
         * <p>
         * The geographic restrictions.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeoRestrictionCustomization.Builder}
         * avoiding the need to create one manually via {@link GeoRestrictionCustomization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeoRestrictionCustomization.Builder#build()} is called
         * immediately and its result is passed to {@link #geoRestrictions(GeoRestrictionCustomization)}.
         * 
         * @param geoRestrictions
         *        a consumer that will call methods on {@link GeoRestrictionCustomization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoRestrictions(GeoRestrictionCustomization)
         */
        default Builder geoRestrictions(Consumer<GeoRestrictionCustomization.Builder> geoRestrictions) {
            return geoRestrictions(GeoRestrictionCustomization.builder().applyMutation(geoRestrictions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WebAclCustomization webAcl;

        private Certificate certificate;

        private GeoRestrictionCustomization geoRestrictions;

        private BuilderImpl() {
        }

        private BuilderImpl(Customizations model) {
            webAcl(model.webAcl);
            certificate(model.certificate);
            geoRestrictions(model.geoRestrictions);
        }

        public final WebAclCustomization.Builder getWebAcl() {
            return webAcl != null ? webAcl.toBuilder() : null;
        }

        public final void setWebAcl(WebAclCustomization.BuilderImpl webAcl) {
            this.webAcl = webAcl != null ? webAcl.build() : null;
        }

        @Override
        public final Builder webAcl(WebAclCustomization webAcl) {
            this.webAcl = webAcl;
            return this;
        }

        public final Certificate.Builder getCertificate() {
            return certificate != null ? certificate.toBuilder() : null;
        }

        public final void setCertificate(Certificate.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        @Override
        public final Builder certificate(Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public final GeoRestrictionCustomization.Builder getGeoRestrictions() {
            return geoRestrictions != null ? geoRestrictions.toBuilder() : null;
        }

        public final void setGeoRestrictions(GeoRestrictionCustomization.BuilderImpl geoRestrictions) {
            this.geoRestrictions = geoRestrictions != null ? geoRestrictions.build() : null;
        }

        @Override
        public final Builder geoRestrictions(GeoRestrictionCustomization geoRestrictions) {
            this.geoRestrictions = geoRestrictions;
            return this;
        }

        @Override
        public Customizations build() {
            return new Customizations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
