/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.waiters.CloudFrontAsyncWaiter;
import software.amazon.awssdk.services.cloudfront.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultCloudFrontAsyncWaiter
implements CloudFrontAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final CloudFrontAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetDistributionResponse> distributionDeployedWaiter;
    private final AsyncWaiter<GetInvalidationResponse> invalidationCompletedWaiter;
    private final AsyncWaiter<GetInvalidationForDistributionTenantResponse> invalidationForDistributionTenantCompletedWaiter;
    private final AsyncWaiter<GetStreamingDistributionResponse> streamingDistributionDeployedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultCloudFrontAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (CloudFrontAsyncClient)CloudFrontAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.distributionDeployedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetDistributionResponse.class).acceptors(DefaultCloudFrontAsyncWaiter.distributionDeployedWaiterAcceptors())).overrideConfiguration(DefaultCloudFrontAsyncWaiter.distributionDeployedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.invalidationCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetInvalidationResponse.class).acceptors(DefaultCloudFrontAsyncWaiter.invalidationCompletedWaiterAcceptors())).overrideConfiguration(DefaultCloudFrontAsyncWaiter.invalidationCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.invalidationForDistributionTenantCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetInvalidationForDistributionTenantResponse.class).acceptors(DefaultCloudFrontAsyncWaiter.invalidationForDistributionTenantCompletedWaiterAcceptors())).overrideConfiguration(DefaultCloudFrontAsyncWaiter.invalidationForDistributionTenantCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.streamingDistributionDeployedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStreamingDistributionResponse.class).acceptors(DefaultCloudFrontAsyncWaiter.streamingDistributionDeployedWaiterAcceptors())).overrideConfiguration(DefaultCloudFrontAsyncWaiter.streamingDistributionDeployedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetDistributionResponse>> waitUntilDistributionDeployed(GetDistributionRequest getDistributionRequest) {
        return this.distributionDeployedWaiter.runAsync(() -> this.client.getDistribution(this.applyWaitersUserAgent(getDistributionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetDistributionResponse>> waitUntilDistributionDeployed(GetDistributionRequest getDistributionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.distributionDeployedWaiter.runAsync(() -> this.client.getDistribution(this.applyWaitersUserAgent(getDistributionRequest)), DefaultCloudFrontAsyncWaiter.distributionDeployedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetInvalidationResponse>> waitUntilInvalidationCompleted(GetInvalidationRequest getInvalidationRequest) {
        return this.invalidationCompletedWaiter.runAsync(() -> this.client.getInvalidation(this.applyWaitersUserAgent(getInvalidationRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetInvalidationResponse>> waitUntilInvalidationCompleted(GetInvalidationRequest getInvalidationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.invalidationCompletedWaiter.runAsync(() -> this.client.getInvalidation(this.applyWaitersUserAgent(getInvalidationRequest)), DefaultCloudFrontAsyncWaiter.invalidationCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetInvalidationForDistributionTenantResponse>> waitUntilInvalidationForDistributionTenantCompleted(GetInvalidationForDistributionTenantRequest getInvalidationForDistributionTenantRequest) {
        return this.invalidationForDistributionTenantCompletedWaiter.runAsync(() -> this.client.getInvalidationForDistributionTenant(this.applyWaitersUserAgent(getInvalidationForDistributionTenantRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetInvalidationForDistributionTenantResponse>> waitUntilInvalidationForDistributionTenantCompleted(GetInvalidationForDistributionTenantRequest getInvalidationForDistributionTenantRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.invalidationForDistributionTenantCompletedWaiter.runAsync(() -> this.client.getInvalidationForDistributionTenant(this.applyWaitersUserAgent(getInvalidationForDistributionTenantRequest)), DefaultCloudFrontAsyncWaiter.invalidationForDistributionTenantCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingDistributionResponse>> waitUntilStreamingDistributionDeployed(GetStreamingDistributionRequest getStreamingDistributionRequest) {
        return this.streamingDistributionDeployedWaiter.runAsync(() -> this.client.getStreamingDistribution(this.applyWaitersUserAgent(getStreamingDistributionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingDistributionResponse>> waitUntilStreamingDistributionDeployed(GetStreamingDistributionRequest getStreamingDistributionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingDistributionDeployedWaiter.runAsync(() -> this.client.getStreamingDistribution(this.applyWaitersUserAgent(getStreamingDistributionRequest)), DefaultCloudFrontAsyncWaiter.streamingDistributionDeployedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetDistributionResponse>> distributionDeployedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetDistributionResponse>> result = new ArrayList<WaiterAcceptor<? super GetDistributionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Distribution").field("Status").value(), "Deployed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetInvalidationResponse>> invalidationCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetInvalidationResponse>> result = new ArrayList<WaiterAcceptor<? super GetInvalidationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Invalidation").field("Status").value(), "Completed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetInvalidationForDistributionTenantResponse>> invalidationForDistributionTenantCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetInvalidationForDistributionTenantResponse>> result = new ArrayList<WaiterAcceptor<? super GetInvalidationForDistributionTenantResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Invalidation").field("Status").value(), "Completed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingDistributionResponse>> streamingDistributionDeployedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingDistributionResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingDistributionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("StreamingDistribution").field("Status").value(), "Deployed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration distributionDeployedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration invalidationCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration invalidationForDistributionTenantCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingDistributionDeployedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(25);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static CloudFrontAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends CloudFrontRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudFrontRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements CloudFrontAsyncWaiter.Builder {
        private CloudFrontAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public CloudFrontAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public CloudFrontAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public CloudFrontAsyncWaiter.Builder client(CloudFrontAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public CloudFrontAsyncWaiter build() {
            return new DefaultCloudFrontAsyncWaiter(this);
        }
    }
}

