/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.waiters.DefaultCloudFrontAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface CloudFrontAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<GetDistributionResponse>> waitUntilDistributionDeployed(GetDistributionRequest getDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetDistributionResponse>> waitUntilDistributionDeployed(Consumer<GetDistributionRequest.Builder> getDistributionRequest) {
        return this.waitUntilDistributionDeployed((GetDistributionRequest)((Object)((GetDistributionRequest.Builder)GetDistributionRequest.builder().applyMutation(getDistributionRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetDistributionResponse>> waitUntilDistributionDeployed(GetDistributionRequest getDistributionRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetDistributionResponse>> waitUntilDistributionDeployed(Consumer<GetDistributionRequest.Builder> getDistributionRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilDistributionDeployed((GetDistributionRequest)((Object)((GetDistributionRequest.Builder)GetDistributionRequest.builder().applyMutation(getDistributionRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetInvalidationResponse>> waitUntilInvalidationCompleted(GetInvalidationRequest getInvalidationRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetInvalidationResponse>> waitUntilInvalidationCompleted(Consumer<GetInvalidationRequest.Builder> getInvalidationRequest) {
        return this.waitUntilInvalidationCompleted((GetInvalidationRequest)((Object)((GetInvalidationRequest.Builder)GetInvalidationRequest.builder().applyMutation(getInvalidationRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetInvalidationResponse>> waitUntilInvalidationCompleted(GetInvalidationRequest getInvalidationRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetInvalidationResponse>> waitUntilInvalidationCompleted(Consumer<GetInvalidationRequest.Builder> getInvalidationRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilInvalidationCompleted((GetInvalidationRequest)((Object)((GetInvalidationRequest.Builder)GetInvalidationRequest.builder().applyMutation(getInvalidationRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetInvalidationForDistributionTenantResponse>> waitUntilInvalidationForDistributionTenantCompleted(GetInvalidationForDistributionTenantRequest getInvalidationForDistributionTenantRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetInvalidationForDistributionTenantResponse>> waitUntilInvalidationForDistributionTenantCompleted(Consumer<GetInvalidationForDistributionTenantRequest.Builder> getInvalidationForDistributionTenantRequest) {
        return this.waitUntilInvalidationForDistributionTenantCompleted((GetInvalidationForDistributionTenantRequest)((Object)((GetInvalidationForDistributionTenantRequest.Builder)GetInvalidationForDistributionTenantRequest.builder().applyMutation(getInvalidationForDistributionTenantRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetInvalidationForDistributionTenantResponse>> waitUntilInvalidationForDistributionTenantCompleted(GetInvalidationForDistributionTenantRequest getInvalidationForDistributionTenantRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetInvalidationForDistributionTenantResponse>> waitUntilInvalidationForDistributionTenantCompleted(Consumer<GetInvalidationForDistributionTenantRequest.Builder> getInvalidationForDistributionTenantRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilInvalidationForDistributionTenantCompleted((GetInvalidationForDistributionTenantRequest)((Object)((GetInvalidationForDistributionTenantRequest.Builder)GetInvalidationForDistributionTenantRequest.builder().applyMutation(getInvalidationForDistributionTenantRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetStreamingDistributionResponse>> waitUntilStreamingDistributionDeployed(GetStreamingDistributionRequest getStreamingDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetStreamingDistributionResponse>> waitUntilStreamingDistributionDeployed(Consumer<GetStreamingDistributionRequest.Builder> getStreamingDistributionRequest) {
        return this.waitUntilStreamingDistributionDeployed((GetStreamingDistributionRequest)((Object)((GetStreamingDistributionRequest.Builder)GetStreamingDistributionRequest.builder().applyMutation(getStreamingDistributionRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetStreamingDistributionResponse>> waitUntilStreamingDistributionDeployed(GetStreamingDistributionRequest getStreamingDistributionRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetStreamingDistributionResponse>> waitUntilStreamingDistributionDeployed(Consumer<GetStreamingDistributionRequest.Builder> getStreamingDistributionRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilStreamingDistributionDeployed((GetStreamingDistributionRequest)((Object)((GetStreamingDistributionRequest.Builder)GetStreamingDistributionRequest.builder().applyMutation(getStreamingDistributionRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultCloudFrontAsyncWaiter.builder();
    }

    public static CloudFrontAsyncWaiter create() {
        return DefaultCloudFrontAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(CloudFrontAsyncClient var1);

        public CloudFrontAsyncWaiter build();
    }
}

