/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationTokenDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidationTokenDetail> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(ValidationTokenDetail.getter(ValidationTokenDetail::domain)).setter(ValidationTokenDetail.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").unmarshallLocationName("Domain").build()}).build();
    private static final SdkField<String> REDIRECT_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedirectTo").getter(ValidationTokenDetail.getter(ValidationTokenDetail::redirectTo)).setter(ValidationTokenDetail.setter(Builder::redirectTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectTo").unmarshallLocationName("RedirectTo").build()}).build();
    private static final SdkField<String> REDIRECT_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedirectFrom").getter(ValidationTokenDetail.getter(ValidationTokenDetail::redirectFrom)).setter(ValidationTokenDetail.setter(Builder::redirectFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectFrom").unmarshallLocationName("RedirectFrom").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, REDIRECT_TO_FIELD, REDIRECT_FROM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidationTokenDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domain;
    private final String redirectTo;
    private final String redirectFrom;

    private ValidationTokenDetail(BuilderImpl builder) {
        this.domain = builder.domain;
        this.redirectTo = builder.redirectTo;
        this.redirectFrom = builder.redirectFrom;
    }

    public final String domain() {
        return this.domain;
    }

    public final String redirectTo() {
        return this.redirectTo;
    }

    public final String redirectFrom() {
        return this.redirectFrom;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectFrom());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationTokenDetail)) {
            return false;
        }
        ValidationTokenDetail other = (ValidationTokenDetail)obj;
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.redirectTo(), other.redirectTo()) && Objects.equals(this.redirectFrom(), other.redirectFrom());
    }

    public final String toString() {
        return ToString.builder((String)"ValidationTokenDetail").add("Domain", (Object)this.domain()).add("RedirectTo", (Object)this.redirectTo()).add("RedirectFrom", (Object)this.redirectFrom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "RedirectTo": {
                return Optional.ofNullable(clazz.cast(this.redirectTo()));
            }
            case "RedirectFrom": {
                return Optional.ofNullable(clazz.cast(this.redirectFrom()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("RedirectTo", REDIRECT_TO_FIELD);
        map.put("RedirectFrom", REDIRECT_FROM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationTokenDetail, T> g) {
        return obj -> g.apply((ValidationTokenDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private String redirectTo;
        private String redirectFrom;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationTokenDetail model) {
            this.domain(model.domain);
            this.redirectTo(model.redirectTo);
            this.redirectFrom(model.redirectFrom);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getRedirectTo() {
            return this.redirectTo;
        }

        public final void setRedirectTo(String redirectTo) {
            this.redirectTo = redirectTo;
        }

        @Override
        public final Builder redirectTo(String redirectTo) {
            this.redirectTo = redirectTo;
            return this;
        }

        public final String getRedirectFrom() {
            return this.redirectFrom;
        }

        public final void setRedirectFrom(String redirectFrom) {
            this.redirectFrom = redirectFrom;
        }

        @Override
        public final Builder redirectFrom(String redirectFrom) {
            this.redirectFrom = redirectFrom;
            return this;
        }

        public ValidationTokenDetail build() {
            return new ValidationTokenDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationTokenDetail> {
        public Builder domain(String var1);

        public Builder redirectTo(String var1);

        public Builder redirectFrom(String var1);
    }
}

