/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;

public class ListCloudFrontOriginAccessIdentitiesIterable
implements SdkIterable<ListCloudFrontOriginAccessIdentitiesResponse> {
    private final CloudFrontClient client;
    private final ListCloudFrontOriginAccessIdentitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCloudFrontOriginAccessIdentitiesIterable(CloudFrontClient client, ListCloudFrontOriginAccessIdentitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCloudFrontOriginAccessIdentitiesResponseFetcher();
    }

    public Iterator<ListCloudFrontOriginAccessIdentitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CloudFrontOriginAccessIdentitySummary> items() {
        Function<ListCloudFrontOriginAccessIdentitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudFrontOriginAccessIdentityList() != null && response.cloudFrontOriginAccessIdentityList().items() != null) {
                return response.cloudFrontOriginAccessIdentityList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCloudFrontOriginAccessIdentitiesResponseFetcher
    implements SyncPageFetcher<ListCloudFrontOriginAccessIdentitiesResponse> {
        private ListCloudFrontOriginAccessIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudFrontOriginAccessIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.cloudFrontOriginAccessIdentityList().nextMarker());
        }

        public ListCloudFrontOriginAccessIdentitiesResponse nextPage(ListCloudFrontOriginAccessIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListCloudFrontOriginAccessIdentitiesIterable.this.client.listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesIterable.this.firstRequest);
            }
            return ListCloudFrontOriginAccessIdentitiesIterable.this.client.listCloudFrontOriginAccessIdentities((ListCloudFrontOriginAccessIdentitiesRequest)((Object)ListCloudFrontOriginAccessIdentitiesIterable.this.firstRequest.toBuilder().marker(previousPage.cloudFrontOriginAccessIdentityList().nextMarker()).build()));
        }
    }
}

