/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDistributionWithStagingConfigRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, UpdateDistributionWithStagingConfigRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateDistributionWithStagingConfigRequest.getter(UpdateDistributionWithStagingConfigRequest::id)).setter(UpdateDistributionWithStagingConfigRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> STAGING_DISTRIBUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StagingDistributionId").getter(UpdateDistributionWithStagingConfigRequest.getter(UpdateDistributionWithStagingConfigRequest::stagingDistributionId)).setter(UpdateDistributionWithStagingConfigRequest.setter(Builder::stagingDistributionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StagingDistributionId").unmarshallLocationName("StagingDistributionId").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(UpdateDistributionWithStagingConfigRequest.getter(UpdateDistributionWithStagingConfigRequest::ifMatch)).setter(UpdateDistributionWithStagingConfigRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").unmarshallLocationName("If-Match").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STAGING_DISTRIBUTION_ID_FIELD, IF_MATCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDistributionWithStagingConfigRequest.memberNameToFieldInitializer();
    private final String id;
    private final String stagingDistributionId;
    private final String ifMatch;

    private UpdateDistributionWithStagingConfigRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.stagingDistributionId = builder.stagingDistributionId;
        this.ifMatch = builder.ifMatch;
    }

    public final String id() {
        return this.id;
    }

    public final String stagingDistributionId() {
        return this.stagingDistributionId;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.stagingDistributionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionWithStagingConfigRequest)) {
            return false;
        }
        UpdateDistributionWithStagingConfigRequest other = (UpdateDistributionWithStagingConfigRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.stagingDistributionId(), other.stagingDistributionId()) && Objects.equals(this.ifMatch(), other.ifMatch());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDistributionWithStagingConfigRequest").add("Id", (Object)this.id()).add("StagingDistributionId", (Object)this.stagingDistributionId()).add("IfMatch", (Object)this.ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "StagingDistributionId": {
                return Optional.ofNullable(clazz.cast(this.stagingDistributionId()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Id", ID_FIELD);
        map.put("StagingDistributionId", STAGING_DISTRIBUTION_ID_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDistributionWithStagingConfigRequest, T> g) {
        return obj -> g.apply((UpdateDistributionWithStagingConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String id;
        private String stagingDistributionId;
        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionWithStagingConfigRequest model) {
            super(model);
            this.id(model.id);
            this.stagingDistributionId(model.stagingDistributionId);
            this.ifMatch(model.ifMatch);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStagingDistributionId() {
            return this.stagingDistributionId;
        }

        public final void setStagingDistributionId(String stagingDistributionId) {
            this.stagingDistributionId = stagingDistributionId;
        }

        @Override
        public final Builder stagingDistributionId(String stagingDistributionId) {
            this.stagingDistributionId = stagingDistributionId;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDistributionWithStagingConfigRequest build() {
            return new UpdateDistributionWithStagingConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDistributionWithStagingConfigRequest> {
        public Builder id(String var1);

        public Builder stagingDistributionId(String var1);

        public Builder ifMatch(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

