/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyType;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentSingleHeaderConfig;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentSingleWeightConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficConfig> {
    private static final SdkField<ContinuousDeploymentSingleWeightConfig> SINGLE_WEIGHT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SingleWeightConfig").getter(TrafficConfig.getter(TrafficConfig::singleWeightConfig)).setter(TrafficConfig.setter(Builder::singleWeightConfig)).constructor(ContinuousDeploymentSingleWeightConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleWeightConfig").unmarshallLocationName("SingleWeightConfig").build()}).build();
    private static final SdkField<ContinuousDeploymentSingleHeaderConfig> SINGLE_HEADER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SingleHeaderConfig").getter(TrafficConfig.getter(TrafficConfig::singleHeaderConfig)).setter(TrafficConfig.setter(Builder::singleHeaderConfig)).constructor(ContinuousDeploymentSingleHeaderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleHeaderConfig").unmarshallLocationName("SingleHeaderConfig").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TrafficConfig.getter(TrafficConfig::typeAsString)).setter(TrafficConfig.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SINGLE_WEIGHT_CONFIG_FIELD, SINGLE_HEADER_CONFIG_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrafficConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ContinuousDeploymentSingleWeightConfig singleWeightConfig;
    private final ContinuousDeploymentSingleHeaderConfig singleHeaderConfig;
    private final String type;

    private TrafficConfig(BuilderImpl builder) {
        this.singleWeightConfig = builder.singleWeightConfig;
        this.singleHeaderConfig = builder.singleHeaderConfig;
        this.type = builder.type;
    }

    public final ContinuousDeploymentSingleWeightConfig singleWeightConfig() {
        return this.singleWeightConfig;
    }

    public final ContinuousDeploymentSingleHeaderConfig singleHeaderConfig() {
        return this.singleHeaderConfig;
    }

    public final ContinuousDeploymentPolicyType type() {
        return ContinuousDeploymentPolicyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.singleWeightConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleHeaderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficConfig)) {
            return false;
        }
        TrafficConfig other = (TrafficConfig)obj;
        return Objects.equals(this.singleWeightConfig(), other.singleWeightConfig()) && Objects.equals(this.singleHeaderConfig(), other.singleHeaderConfig()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TrafficConfig").add("SingleWeightConfig", (Object)this.singleWeightConfig()).add("SingleHeaderConfig", (Object)this.singleHeaderConfig()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SingleWeightConfig": {
                return Optional.ofNullable(clazz.cast(this.singleWeightConfig()));
            }
            case "SingleHeaderConfig": {
                return Optional.ofNullable(clazz.cast(this.singleHeaderConfig()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SingleWeightConfig", SINGLE_WEIGHT_CONFIG_FIELD);
        map.put("SingleHeaderConfig", SINGLE_HEADER_CONFIG_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrafficConfig, T> g) {
        return obj -> g.apply((TrafficConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ContinuousDeploymentSingleWeightConfig singleWeightConfig;
        private ContinuousDeploymentSingleHeaderConfig singleHeaderConfig;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficConfig model) {
            this.singleWeightConfig(model.singleWeightConfig);
            this.singleHeaderConfig(model.singleHeaderConfig);
            this.type(model.type);
        }

        public final ContinuousDeploymentSingleWeightConfig.Builder getSingleWeightConfig() {
            return this.singleWeightConfig != null ? this.singleWeightConfig.toBuilder() : null;
        }

        public final void setSingleWeightConfig(ContinuousDeploymentSingleWeightConfig.BuilderImpl singleWeightConfig) {
            this.singleWeightConfig = singleWeightConfig != null ? singleWeightConfig.build() : null;
        }

        @Override
        public final Builder singleWeightConfig(ContinuousDeploymentSingleWeightConfig singleWeightConfig) {
            this.singleWeightConfig = singleWeightConfig;
            return this;
        }

        public final ContinuousDeploymentSingleHeaderConfig.Builder getSingleHeaderConfig() {
            return this.singleHeaderConfig != null ? this.singleHeaderConfig.toBuilder() : null;
        }

        public final void setSingleHeaderConfig(ContinuousDeploymentSingleHeaderConfig.BuilderImpl singleHeaderConfig) {
            this.singleHeaderConfig = singleHeaderConfig != null ? singleHeaderConfig.build() : null;
        }

        @Override
        public final Builder singleHeaderConfig(ContinuousDeploymentSingleHeaderConfig singleHeaderConfig) {
            this.singleHeaderConfig = singleHeaderConfig;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContinuousDeploymentPolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public TrafficConfig build() {
            return new TrafficConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficConfig> {
        public Builder singleWeightConfig(ContinuousDeploymentSingleWeightConfig var1);

        default public Builder singleWeightConfig(Consumer<ContinuousDeploymentSingleWeightConfig.Builder> singleWeightConfig) {
            return this.singleWeightConfig((ContinuousDeploymentSingleWeightConfig)((ContinuousDeploymentSingleWeightConfig.Builder)ContinuousDeploymentSingleWeightConfig.builder().applyMutation(singleWeightConfig)).build());
        }

        public Builder singleHeaderConfig(ContinuousDeploymentSingleHeaderConfig var1);

        default public Builder singleHeaderConfig(Consumer<ContinuousDeploymentSingleHeaderConfig.Builder> singleHeaderConfig) {
            return this.singleHeaderConfig((ContinuousDeploymentSingleHeaderConfig)((ContinuousDeploymentSingleHeaderConfig.Builder)ContinuousDeploymentSingleHeaderConfig.builder().applyMutation(singleHeaderConfig)).build());
        }

        public Builder type(String var1);

        public Builder type(ContinuousDeploymentPolicyType var1);
    }
}

