/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CachePolicy;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCachePolicyResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetCachePolicyResponse> {
    private static final SdkField<CachePolicy> CACHE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CachePolicy").getter(GetCachePolicyResponse.getter(GetCachePolicyResponse::cachePolicy)).setter(GetCachePolicyResponse.setter(Builder::cachePolicy)).constructor(CachePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicy").unmarshallLocationName("CachePolicy").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetCachePolicyResponse.getter(GetCachePolicyResponse::eTag)).setter(GetCachePolicyResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_POLICY_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCachePolicyResponse.memberNameToFieldInitializer();
    private final CachePolicy cachePolicy;
    private final String eTag;

    private GetCachePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.cachePolicy = builder.cachePolicy;
        this.eTag = builder.eTag;
    }

    public final CachePolicy cachePolicy() {
        return this.cachePolicy;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cachePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCachePolicyResponse)) {
            return false;
        }
        GetCachePolicyResponse other = (GetCachePolicyResponse)((Object)obj);
        return Objects.equals(this.cachePolicy(), other.cachePolicy()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetCachePolicyResponse").add("CachePolicy", (Object)this.cachePolicy()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CachePolicy": {
                return Optional.ofNullable(clazz.cast(this.cachePolicy()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CachePolicy", CACHE_POLICY_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCachePolicyResponse, T> g) {
        return obj -> g.apply((GetCachePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private CachePolicy cachePolicy;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCachePolicyResponse model) {
            super(model);
            this.cachePolicy(model.cachePolicy);
            this.eTag(model.eTag);
        }

        public final CachePolicy.Builder getCachePolicy() {
            return this.cachePolicy != null ? this.cachePolicy.toBuilder() : null;
        }

        public final void setCachePolicy(CachePolicy.BuilderImpl cachePolicy) {
            this.cachePolicy = cachePolicy != null ? cachePolicy.build() : null;
        }

        @Override
        public final Builder cachePolicy(CachePolicy cachePolicy) {
            this.cachePolicy = cachePolicy;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetCachePolicyResponse build() {
            return new GetCachePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCachePolicyResponse> {
        public Builder cachePolicy(CachePolicy var1);

        default public Builder cachePolicy(Consumer<CachePolicy.Builder> cachePolicy) {
            return this.cachePolicy((CachePolicy)((CachePolicy.Builder)CachePolicy.builder().applyMutation(cachePolicy)).build());
        }

        public Builder eTag(String var1);
    }
}

