/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVpcOriginResponse extends CloudFrontResponse implements
        ToCopyableBuilder<UpdateVpcOriginResponse.Builder, UpdateVpcOriginResponse> {
    private static final SdkField<VpcOrigin> VPC_ORIGIN_FIELD = SdkField
            .<VpcOrigin> builder(MarshallingType.SDK_POJO)
            .memberName("VpcOrigin")
            .getter(getter(UpdateVpcOriginResponse::vpcOrigin))
            .setter(setter(Builder::vpcOrigin))
            .constructor(VpcOrigin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOrigin")
                    .unmarshallLocationName("VpcOrigin").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(UpdateVpcOriginResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VPC_ORIGIN_FIELD, E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcOrigin vpcOrigin;

    private final String eTag;

    private UpdateVpcOriginResponse(BuilderImpl builder) {
        super(builder);
        this.vpcOrigin = builder.vpcOrigin;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The VPC origin.
     * </p>
     * 
     * @return The VPC origin.
     */
    public final VpcOrigin vpcOrigin() {
        return vpcOrigin;
    }

    /**
     * <p>
     * The VPC origin ETag.
     * </p>
     * 
     * @return The VPC origin ETag.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcOrigin());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcOriginResponse)) {
            return false;
        }
        UpdateVpcOriginResponse other = (UpdateVpcOriginResponse) obj;
        return Objects.equals(vpcOrigin(), other.vpcOrigin()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVpcOriginResponse").add("VpcOrigin", vpcOrigin()).add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcOrigin":
            return Optional.ofNullable(clazz.cast(vpcOrigin()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcOrigin", VPC_ORIGIN_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcOriginResponse, T> g) {
        return obj -> g.apply((UpdateVpcOriginResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVpcOriginResponse> {
        /**
         * <p>
         * The VPC origin.
         * </p>
         * 
         * @param vpcOrigin
         *        The VPC origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOrigin(VpcOrigin vpcOrigin);

        /**
         * <p>
         * The VPC origin.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcOrigin.Builder} avoiding the need to
         * create one manually via {@link VpcOrigin#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcOrigin.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcOrigin(VpcOrigin)}.
         * 
         * @param vpcOrigin
         *        a consumer that will call methods on {@link VpcOrigin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOrigin(VpcOrigin)
         */
        default Builder vpcOrigin(Consumer<VpcOrigin.Builder> vpcOrigin) {
            return vpcOrigin(VpcOrigin.builder().applyMutation(vpcOrigin).build());
        }

        /**
         * <p>
         * The VPC origin ETag.
         * </p>
         * 
         * @param eTag
         *        The VPC origin ETag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private VpcOrigin vpcOrigin;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcOriginResponse model) {
            super(model);
            vpcOrigin(model.vpcOrigin);
            eTag(model.eTag);
        }

        public final VpcOrigin.Builder getVpcOrigin() {
            return vpcOrigin != null ? vpcOrigin.toBuilder() : null;
        }

        public final void setVpcOrigin(VpcOrigin.BuilderImpl vpcOrigin) {
            this.vpcOrigin = vpcOrigin != null ? vpcOrigin.build() : null;
        }

        @Override
        public final Builder vpcOrigin(VpcOrigin vpcOrigin) {
            this.vpcOrigin = vpcOrigin;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public UpdateVpcOriginResponse build() {
            return new UpdateVpcOriginResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
