/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A CloudFront origin access control configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginAccessControlConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OriginAccessControlConfig.Builder, OriginAccessControlConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(OriginAccessControlConfig::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(OriginAccessControlConfig::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> SIGNING_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SigningProtocol")
            .getter(getter(OriginAccessControlConfig::signingProtocolAsString))
            .setter(setter(Builder::signingProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningProtocol")
                    .unmarshallLocationName("SigningProtocol").build()).build();

    private static final SdkField<String> SIGNING_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SigningBehavior")
            .getter(getter(OriginAccessControlConfig::signingBehaviorAsString))
            .setter(setter(Builder::signingBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningBehavior")
                    .unmarshallLocationName("SigningBehavior").build()).build();

    private static final SdkField<String> ORIGIN_ACCESS_CONTROL_ORIGIN_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OriginAccessControlOriginType")
            .getter(getter(OriginAccessControlConfig::originAccessControlOriginTypeAsString))
            .setter(setter(Builder::originAccessControlOriginType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessControlOriginType")
                    .unmarshallLocationName("OriginAccessControlOriginType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SIGNING_PROTOCOL_FIELD, SIGNING_BEHAVIOR_FIELD, ORIGIN_ACCESS_CONTROL_ORIGIN_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String signingProtocol;

    private final String signingBehavior;

    private final String originAccessControlOriginType;

    private OriginAccessControlConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.signingProtocol = builder.signingProtocol;
        this.signingBehavior = builder.signingBehavior;
        this.originAccessControlOriginType = builder.originAccessControlOriginType;
    }

    /**
     * <p>
     * A name to identify the origin access control. You can specify up to 64 characters.
     * </p>
     * 
     * @return A name to identify the origin access control. You can specify up to 64 characters.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the origin access control.
     * </p>
     * 
     * @return A description of the origin access control.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The signing protocol of the origin access control, which determines how CloudFront signs (authenticates)
     * requests. The only valid value is <code>sigv4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingProtocol}
     * will return {@link OriginAccessControlSigningProtocols#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #signingProtocolAsString}.
     * </p>
     * 
     * @return The signing protocol of the origin access control, which determines how CloudFront signs (authenticates)
     *         requests. The only valid value is <code>sigv4</code>.
     * @see OriginAccessControlSigningProtocols
     */
    public final OriginAccessControlSigningProtocols signingProtocol() {
        return OriginAccessControlSigningProtocols.fromValue(signingProtocol);
    }

    /**
     * <p>
     * The signing protocol of the origin access control, which determines how CloudFront signs (authenticates)
     * requests. The only valid value is <code>sigv4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingProtocol}
     * will return {@link OriginAccessControlSigningProtocols#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #signingProtocolAsString}.
     * </p>
     * 
     * @return The signing protocol of the origin access control, which determines how CloudFront signs (authenticates)
     *         requests. The only valid value is <code>sigv4</code>.
     * @see OriginAccessControlSigningProtocols
     */
    public final String signingProtocolAsString() {
        return signingProtocol;
    }

    /**
     * <p>
     * Specifies which requests CloudFront signs (adds authentication information to). Specify <code>always</code> for
     * the most common use case. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings"
     * >origin access control advanced settings</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * This field can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code> header
     * from the viewer request if one exists.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>never</code> – CloudFront doesn't sign any origin requests. This value turns off origin access control for
     * all origins in all distributions that use this origin access control.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header, then
     * CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code> header, then
     * CloudFront doesn't sign the origin request and instead passes along the <code>Authorization</code> header from
     * the viewer request. <b>WARNING: To pass along the <code>Authorization</code> header from the viewer request, you
     * <i>must</i> add the <code>Authorization</code> header to a <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html">cache
     * policy</a> for all cache behaviors that use origins associated with this origin access control.</b>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingBehavior}
     * will return {@link OriginAccessControlSigningBehaviors#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #signingBehaviorAsString}.
     * </p>
     * 
     * @return Specifies which requests CloudFront signs (adds authentication information to). Specify
     *         <code>always</code> for the most common use case. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings"
     *         >origin access control advanced settings</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
     *         <p>
     *         This field can have one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code>
     *         header from the viewer request if one exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>never</code> – CloudFront doesn't sign any origin requests. This value turns off origin access
     *         control for all origins in all distributions that use this origin access control.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header,
     *         then CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code>
     *         header, then CloudFront doesn't sign the origin request and instead passes along the
     *         <code>Authorization</code> header from the viewer request. <b>WARNING: To pass along the
     *         <code>Authorization</code> header from the viewer request, you <i>must</i> add the
     *         <code>Authorization</code> header to a <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html"
     *         >cache policy</a> for all cache behaviors that use origins associated with this origin access
     *         control.</b>
     *         </p>
     *         </li>
     * @see OriginAccessControlSigningBehaviors
     */
    public final OriginAccessControlSigningBehaviors signingBehavior() {
        return OriginAccessControlSigningBehaviors.fromValue(signingBehavior);
    }

    /**
     * <p>
     * Specifies which requests CloudFront signs (adds authentication information to). Specify <code>always</code> for
     * the most common use case. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings"
     * >origin access control advanced settings</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * This field can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code> header
     * from the viewer request if one exists.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>never</code> – CloudFront doesn't sign any origin requests. This value turns off origin access control for
     * all origins in all distributions that use this origin access control.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header, then
     * CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code> header, then
     * CloudFront doesn't sign the origin request and instead passes along the <code>Authorization</code> header from
     * the viewer request. <b>WARNING: To pass along the <code>Authorization</code> header from the viewer request, you
     * <i>must</i> add the <code>Authorization</code> header to a <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html">cache
     * policy</a> for all cache behaviors that use origins associated with this origin access control.</b>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingBehavior}
     * will return {@link OriginAccessControlSigningBehaviors#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #signingBehaviorAsString}.
     * </p>
     * 
     * @return Specifies which requests CloudFront signs (adds authentication information to). Specify
     *         <code>always</code> for the most common use case. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings"
     *         >origin access control advanced settings</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
     *         <p>
     *         This field can have one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code>
     *         header from the viewer request if one exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>never</code> – CloudFront doesn't sign any origin requests. This value turns off origin access
     *         control for all origins in all distributions that use this origin access control.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header,
     *         then CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code>
     *         header, then CloudFront doesn't sign the origin request and instead passes along the
     *         <code>Authorization</code> header from the viewer request. <b>WARNING: To pass along the
     *         <code>Authorization</code> header from the viewer request, you <i>must</i> add the
     *         <code>Authorization</code> header to a <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html"
     *         >cache policy</a> for all cache behaviors that use origins associated with this origin access
     *         control.</b>
     *         </p>
     *         </li>
     * @see OriginAccessControlSigningBehaviors
     */
    public final String signingBehaviorAsString() {
        return signingBehavior;
    }

    /**
     * <p>
     * The type of origin that this origin access control is for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originAccessControlOriginType} will return {@link OriginAccessControlOriginTypes#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #originAccessControlOriginTypeAsString}.
     * </p>
     * 
     * @return The type of origin that this origin access control is for.
     * @see OriginAccessControlOriginTypes
     */
    public final OriginAccessControlOriginTypes originAccessControlOriginType() {
        return OriginAccessControlOriginTypes.fromValue(originAccessControlOriginType);
    }

    /**
     * <p>
     * The type of origin that this origin access control is for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originAccessControlOriginType} will return {@link OriginAccessControlOriginTypes#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #originAccessControlOriginTypeAsString}.
     * </p>
     * 
     * @return The type of origin that this origin access control is for.
     * @see OriginAccessControlOriginTypes
     */
    public final String originAccessControlOriginTypeAsString() {
        return originAccessControlOriginType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(signingProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(signingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originAccessControlOriginTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginAccessControlConfig)) {
            return false;
        }
        OriginAccessControlConfig other = (OriginAccessControlConfig) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(signingProtocolAsString(), other.signingProtocolAsString())
                && Objects.equals(signingBehaviorAsString(), other.signingBehaviorAsString())
                && Objects.equals(originAccessControlOriginTypeAsString(), other.originAccessControlOriginTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OriginAccessControlConfig").add("Name", name()).add("Description", description())
                .add("SigningProtocol", signingProtocolAsString()).add("SigningBehavior", signingBehaviorAsString())
                .add("OriginAccessControlOriginType", originAccessControlOriginTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SigningProtocol":
            return Optional.ofNullable(clazz.cast(signingProtocolAsString()));
        case "SigningBehavior":
            return Optional.ofNullable(clazz.cast(signingBehaviorAsString()));
        case "OriginAccessControlOriginType":
            return Optional.ofNullable(clazz.cast(originAccessControlOriginTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SigningProtocol", SIGNING_PROTOCOL_FIELD);
        map.put("SigningBehavior", SIGNING_BEHAVIOR_FIELD);
        map.put("OriginAccessControlOriginType", ORIGIN_ACCESS_CONTROL_ORIGIN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OriginAccessControlConfig, T> g) {
        return obj -> g.apply((OriginAccessControlConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginAccessControlConfig> {
        /**
         * <p>
         * A name to identify the origin access control. You can specify up to 64 characters.
         * </p>
         * 
         * @param name
         *        A name to identify the origin access control. You can specify up to 64 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the origin access control.
         * </p>
         * 
         * @param description
         *        A description of the origin access control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The signing protocol of the origin access control, which determines how CloudFront signs (authenticates)
         * requests. The only valid value is <code>sigv4</code>.
         * </p>
         * 
         * @param signingProtocol
         *        The signing protocol of the origin access control, which determines how CloudFront signs
         *        (authenticates) requests. The only valid value is <code>sigv4</code>.
         * @see OriginAccessControlSigningProtocols
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginAccessControlSigningProtocols
         */
        Builder signingProtocol(String signingProtocol);

        /**
         * <p>
         * The signing protocol of the origin access control, which determines how CloudFront signs (authenticates)
         * requests. The only valid value is <code>sigv4</code>.
         * </p>
         * 
         * @param signingProtocol
         *        The signing protocol of the origin access control, which determines how CloudFront signs
         *        (authenticates) requests. The only valid value is <code>sigv4</code>.
         * @see OriginAccessControlSigningProtocols
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginAccessControlSigningProtocols
         */
        Builder signingProtocol(OriginAccessControlSigningProtocols signingProtocol);

        /**
         * <p>
         * Specifies which requests CloudFront signs (adds authentication information to). Specify <code>always</code>
         * for the most common use case. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings"
         * >origin access control advanced settings</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * This field can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code> header
         * from the viewer request if one exists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>never</code> – CloudFront doesn't sign any origin requests. This value turns off origin access control
         * for all origins in all distributions that use this origin access control.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header, then
         * CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code> header,
         * then CloudFront doesn't sign the origin request and instead passes along the <code>Authorization</code>
         * header from the viewer request. <b>WARNING: To pass along the <code>Authorization</code> header from the
         * viewer request, you <i>must</i> add the <code>Authorization</code> header to a <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html"
         * >cache policy</a> for all cache behaviors that use origins associated with this origin access control.</b>
         * </p>
         * </li>
         * </ul>
         * 
         * @param signingBehavior
         *        Specifies which requests CloudFront signs (adds authentication information to). Specify
         *        <code>always</code> for the most common use case. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings"
         *        >origin access control advanced settings</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
         *        <p>
         *        This field can have one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code>
         *        header from the viewer request if one exists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>never</code> – CloudFront doesn't sign any origin requests. This value turns off origin access
         *        control for all origins in all distributions that use this origin access control.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code>
         *        header, then CloudFront signs the origin request. If the viewer request contains the
         *        <code>Authorization</code> header, then CloudFront doesn't sign the origin request and instead passes
         *        along the <code>Authorization</code> header from the viewer request. <b>WARNING: To pass along the
         *        <code>Authorization</code> header from the viewer request, you <i>must</i> add the
         *        <code>Authorization</code> header to a <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html"
         *        >cache policy</a> for all cache behaviors that use origins associated with this origin access
         *        control.</b>
         *        </p>
         *        </li>
         * @see OriginAccessControlSigningBehaviors
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginAccessControlSigningBehaviors
         */
        Builder signingBehavior(String signingBehavior);

        /**
         * <p>
         * Specifies which requests CloudFront signs (adds authentication information to). Specify <code>always</code>
         * for the most common use case. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings"
         * >origin access control advanced settings</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * This field can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code> header
         * from the viewer request if one exists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>never</code> – CloudFront doesn't sign any origin requests. This value turns off origin access control
         * for all origins in all distributions that use this origin access control.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header, then
         * CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code> header,
         * then CloudFront doesn't sign the origin request and instead passes along the <code>Authorization</code>
         * header from the viewer request. <b>WARNING: To pass along the <code>Authorization</code> header from the
         * viewer request, you <i>must</i> add the <code>Authorization</code> header to a <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html"
         * >cache policy</a> for all cache behaviors that use origins associated with this origin access control.</b>
         * </p>
         * </li>
         * </ul>
         * 
         * @param signingBehavior
         *        Specifies which requests CloudFront signs (adds authentication information to). Specify
         *        <code>always</code> for the most common use case. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings"
         *        >origin access control advanced settings</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
         *        <p>
         *        This field can have one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code>
         *        header from the viewer request if one exists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>never</code> – CloudFront doesn't sign any origin requests. This value turns off origin access
         *        control for all origins in all distributions that use this origin access control.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code>
         *        header, then CloudFront signs the origin request. If the viewer request contains the
         *        <code>Authorization</code> header, then CloudFront doesn't sign the origin request and instead passes
         *        along the <code>Authorization</code> header from the viewer request. <b>WARNING: To pass along the
         *        <code>Authorization</code> header from the viewer request, you <i>must</i> add the
         *        <code>Authorization</code> header to a <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html"
         *        >cache policy</a> for all cache behaviors that use origins associated with this origin access
         *        control.</b>
         *        </p>
         *        </li>
         * @see OriginAccessControlSigningBehaviors
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginAccessControlSigningBehaviors
         */
        Builder signingBehavior(OriginAccessControlSigningBehaviors signingBehavior);

        /**
         * <p>
         * The type of origin that this origin access control is for.
         * </p>
         * 
         * @param originAccessControlOriginType
         *        The type of origin that this origin access control is for.
         * @see OriginAccessControlOriginTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginAccessControlOriginTypes
         */
        Builder originAccessControlOriginType(String originAccessControlOriginType);

        /**
         * <p>
         * The type of origin that this origin access control is for.
         * </p>
         * 
         * @param originAccessControlOriginType
         *        The type of origin that this origin access control is for.
         * @see OriginAccessControlOriginTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginAccessControlOriginTypes
         */
        Builder originAccessControlOriginType(OriginAccessControlOriginTypes originAccessControlOriginType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String signingProtocol;

        private String signingBehavior;

        private String originAccessControlOriginType;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginAccessControlConfig model) {
            name(model.name);
            description(model.description);
            signingProtocol(model.signingProtocol);
            signingBehavior(model.signingBehavior);
            originAccessControlOriginType(model.originAccessControlOriginType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSigningProtocol() {
            return signingProtocol;
        }

        public final void setSigningProtocol(String signingProtocol) {
            this.signingProtocol = signingProtocol;
        }

        @Override
        public final Builder signingProtocol(String signingProtocol) {
            this.signingProtocol = signingProtocol;
            return this;
        }

        @Override
        public final Builder signingProtocol(OriginAccessControlSigningProtocols signingProtocol) {
            this.signingProtocol(signingProtocol == null ? null : signingProtocol.toString());
            return this;
        }

        public final String getSigningBehavior() {
            return signingBehavior;
        }

        public final void setSigningBehavior(String signingBehavior) {
            this.signingBehavior = signingBehavior;
        }

        @Override
        public final Builder signingBehavior(String signingBehavior) {
            this.signingBehavior = signingBehavior;
            return this;
        }

        @Override
        public final Builder signingBehavior(OriginAccessControlSigningBehaviors signingBehavior) {
            this.signingBehavior(signingBehavior == null ? null : signingBehavior.toString());
            return this;
        }

        public final String getOriginAccessControlOriginType() {
            return originAccessControlOriginType;
        }

        public final void setOriginAccessControlOriginType(String originAccessControlOriginType) {
            this.originAccessControlOriginType = originAccessControlOriginType;
        }

        @Override
        public final Builder originAccessControlOriginType(String originAccessControlOriginType) {
            this.originAccessControlOriginType = originAccessControlOriginType;
            return this;
        }

        @Override
        public final Builder originAccessControlOriginType(OriginAccessControlOriginTypes originAccessControlOriginType) {
            this.originAccessControlOriginType(originAccessControlOriginType == null ? null : originAccessControlOriginType
                    .toString());
            return this;
        }

        @Override
        public OriginAccessControlConfig build() {
            return new OriginAccessControlConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
