/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A CloudFront origin access control, including its unique identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginAccessControl implements SdkPojo, Serializable,
        ToCopyableBuilder<OriginAccessControl.Builder, OriginAccessControl> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(OriginAccessControl::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<OriginAccessControlConfig> ORIGIN_ACCESS_CONTROL_CONFIG_FIELD = SdkField
            .<OriginAccessControlConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OriginAccessControlConfig")
            .getter(getter(OriginAccessControl::originAccessControlConfig))
            .setter(setter(Builder::originAccessControlConfig))
            .constructor(OriginAccessControlConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessControlConfig")
                    .unmarshallLocationName("OriginAccessControlConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            ORIGIN_ACCESS_CONTROL_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final OriginAccessControlConfig originAccessControlConfig;

    private OriginAccessControl(BuilderImpl builder) {
        this.id = builder.id;
        this.originAccessControlConfig = builder.originAccessControlConfig;
    }

    /**
     * <p>
     * The unique identifier of the origin access control.
     * </p>
     * 
     * @return The unique identifier of the origin access control.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The origin access control.
     * </p>
     * 
     * @return The origin access control.
     */
    public final OriginAccessControlConfig originAccessControlConfig() {
        return originAccessControlConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(originAccessControlConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginAccessControl)) {
            return false;
        }
        OriginAccessControl other = (OriginAccessControl) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(originAccessControlConfig(), other.originAccessControlConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OriginAccessControl").add("Id", id())
                .add("OriginAccessControlConfig", originAccessControlConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "OriginAccessControlConfig":
            return Optional.ofNullable(clazz.cast(originAccessControlConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("OriginAccessControlConfig", ORIGIN_ACCESS_CONTROL_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OriginAccessControl, T> g) {
        return obj -> g.apply((OriginAccessControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginAccessControl> {
        /**
         * <p>
         * The unique identifier of the origin access control.
         * </p>
         * 
         * @param id
         *        The unique identifier of the origin access control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The origin access control.
         * </p>
         * 
         * @param originAccessControlConfig
         *        The origin access control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originAccessControlConfig(OriginAccessControlConfig originAccessControlConfig);

        /**
         * <p>
         * The origin access control.
         * </p>
         * This is a convenience method that creates an instance of the {@link OriginAccessControlConfig.Builder}
         * avoiding the need to create one manually via {@link OriginAccessControlConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OriginAccessControlConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #originAccessControlConfig(OriginAccessControlConfig)}.
         * 
         * @param originAccessControlConfig
         *        a consumer that will call methods on {@link OriginAccessControlConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originAccessControlConfig(OriginAccessControlConfig)
         */
        default Builder originAccessControlConfig(Consumer<OriginAccessControlConfig.Builder> originAccessControlConfig) {
            return originAccessControlConfig(OriginAccessControlConfig.builder().applyMutation(originAccessControlConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private OriginAccessControlConfig originAccessControlConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginAccessControl model) {
            id(model.id);
            originAccessControlConfig(model.originAccessControlConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final OriginAccessControlConfig.Builder getOriginAccessControlConfig() {
            return originAccessControlConfig != null ? originAccessControlConfig.toBuilder() : null;
        }

        public final void setOriginAccessControlConfig(OriginAccessControlConfig.BuilderImpl originAccessControlConfig) {
            this.originAccessControlConfig = originAccessControlConfig != null ? originAccessControlConfig.build() : null;
        }

        @Override
        public final Builder originAccessControlConfig(OriginAccessControlConfig originAccessControlConfig) {
            this.originAccessControlConfig = originAccessControlConfig;
            return this;
        }

        @Override
        public OriginAccessControl build() {
            return new OriginAccessControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
