/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKeyValueStoreRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateKeyValueStoreRequest.Builder, CreateKeyValueStoreRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(CreateKeyValueStoreRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(CreateKeyValueStoreRequest::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<ImportSource> IMPORT_SOURCE_FIELD = SdkField
            .<ImportSource> builder(MarshallingType.SDK_POJO)
            .memberName("ImportSource")
            .getter(getter(CreateKeyValueStoreRequest::importSource))
            .setter(setter(Builder::importSource))
            .constructor(ImportSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportSource")
                    .unmarshallLocationName("ImportSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, COMMENT_FIELD,
            IMPORT_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String comment;

    private final ImportSource importSource;

    private CreateKeyValueStoreRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.comment = builder.comment;
        this.importSource = builder.importSource;
    }

    /**
     * <p>
     * The name of the key value store. The minimum length is 1 character and the maximum length is 64 characters.
     * </p>
     * 
     * @return The name of the key value store. The minimum length is 1 character and the maximum length is 64
     *         characters.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The comment of the key value store.
     * </p>
     * 
     * @return The comment of the key value store.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The S3 bucket that provides the source for the import. The source must be in a valid JSON format.
     * </p>
     * 
     * @return The S3 bucket that provides the source for the import. The source must be in a valid JSON format.
     */
    public final ImportSource importSource() {
        return importSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(importSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyValueStoreRequest)) {
            return false;
        }
        CreateKeyValueStoreRequest other = (CreateKeyValueStoreRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(comment(), other.comment())
                && Objects.equals(importSource(), other.importSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKeyValueStoreRequest").add("Name", name()).add("Comment", comment())
                .add("ImportSource", importSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "ImportSource":
            return Optional.ofNullable(clazz.cast(importSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Comment", COMMENT_FIELD);
        map.put("ImportSource", IMPORT_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyValueStoreRequest, T> g) {
        return obj -> g.apply((CreateKeyValueStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateKeyValueStoreRequest> {
        /**
         * <p>
         * The name of the key value store. The minimum length is 1 character and the maximum length is 64 characters.
         * </p>
         * 
         * @param name
         *        The name of the key value store. The minimum length is 1 character and the maximum length is 64
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The comment of the key value store.
         * </p>
         * 
         * @param comment
         *        The comment of the key value store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The S3 bucket that provides the source for the import. The source must be in a valid JSON format.
         * </p>
         * 
         * @param importSource
         *        The S3 bucket that provides the source for the import. The source must be in a valid JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSource(ImportSource importSource);

        /**
         * <p>
         * The S3 bucket that provides the source for the import. The source must be in a valid JSON format.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportSource.Builder} avoiding the need
         * to create one manually via {@link ImportSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportSource.Builder#build()} is called immediately and its
         * result is passed to {@link #importSource(ImportSource)}.
         * 
         * @param importSource
         *        a consumer that will call methods on {@link ImportSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importSource(ImportSource)
         */
        default Builder importSource(Consumer<ImportSource.Builder> importSource) {
            return importSource(ImportSource.builder().applyMutation(importSource).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String name;

        private String comment;

        private ImportSource importSource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyValueStoreRequest model) {
            super(model);
            name(model.name);
            comment(model.comment);
            importSource(model.importSource);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final ImportSource.Builder getImportSource() {
            return importSource != null ? importSource.toBuilder() : null;
        }

        public final void setImportSource(ImportSource.BuilderImpl importSource) {
            this.importSource = importSource != null ? importSource.build() : null;
        }

        @Override
        public final Builder importSource(ImportSource importSource) {
            this.importSource = importSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKeyValueStoreRequest build() {
            return new CreateKeyValueStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
